/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.sysoutslf4j.system;

import java.lang.reflect.Method;
import uk.org.lidalia.sysoutslf4j.common.LoggerAppender;
import uk.org.lidalia.sysoutslf4j.common.ReflectionUtils;

final class LoggerAppenderProxy
implements LoggerAppender {
    private final Object targetLoggerAppender;
    private final Method appendMethod;
    private final Method appendAndLogMethod;

    private LoggerAppenderProxy(Object targetLoggerAppender) {
        try {
            Class<?> loggerAppenderClass = targetLoggerAppender.getClass();
            this.targetLoggerAppender = targetLoggerAppender;
            this.appendMethod = loggerAppenderClass.getDeclaredMethod("append", String.class);
            this.appendAndLogMethod = loggerAppenderClass.getDeclaredMethod("appendAndLog", String.class, String.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Must only be instantiated with a LoggerAppender instance, got a " + targetLoggerAppender.getClass(), e);
        }
    }

    @Override
    public void append(String message) {
        ReflectionUtils.invokeMethod(this.appendMethod, this.targetLoggerAppender, message);
    }

    @Override
    public void appendAndLog(String message, String className, boolean isStackTrace) {
        ReflectionUtils.invokeMethod(this.appendAndLogMethod, this.targetLoggerAppender, message, className, isStackTrace);
    }

    static LoggerAppender wrap(Object targetLoggerAppender) {
        LoggerAppender result = targetLoggerAppender instanceof LoggerAppender ? (LoggerAppender)targetLoggerAppender : new LoggerAppenderProxy(targetLoggerAppender);
        return result;
    }
}

