/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.text;

import org.thymeleaf.templateparser.text.ITextHandler;
import org.thymeleaf.templateparser.text.TextParseException;

final class TextParsingCommentUtil {
    private TextParsingCommentUtil() {
    }

    public static void parseComment(char[] buffer, int offset, int len, int line, int col, ITextHandler handler) throws TextParseException {
        if (len < 4 || !TextParsingCommentUtil.isCommentStart(buffer, offset, offset + len) || !TextParsingCommentUtil.isCommentEnd(buffer, offset + len - 2, offset + len)) {
            throw new TextParseException("Could not parse as a well-formed Comment: \"" + new String(buffer, offset, len) + "\"", line, col);
        }
        int contentOffset = offset + 2;
        int contentLen = len - 4;
        handler.handleComment(buffer, contentOffset, contentLen, offset, len, line, col);
    }

    static boolean isCommentStart(char[] buffer, int offset, int maxi) {
        return maxi - offset > 1 && buffer[offset] == '/' && buffer[offset + 1] == '*';
    }

    static boolean isCommentEnd(char[] buffer, int offset, int maxi) {
        return maxi - offset > 1 && buffer[offset] == '*' && buffer[offset + 1] == '/';
    }
}

