/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.otp;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.jboss.aerogear.security.otp.api.Base32;
import org.jboss.aerogear.security.otp.api.Clock;
import org.jboss.aerogear.security.otp.api.Digits;
import org.jboss.aerogear.security.otp.api.Hash;
import org.jboss.aerogear.security.otp.api.Hmac;

public class Totp {
    private final String secret;
    private final Clock clock;
    private static final int DELAY_WINDOW = 1;

    public Totp(String secret) {
        this.secret = secret;
        this.clock = new Clock();
    }

    public Totp(String secret, Clock clock) {
        this.secret = secret;
        this.clock = clock;
    }

    public String uri(String name) {
        try {
            return String.format("otpauth://totp/%s?secret=%s", URLEncoder.encode(name, "UTF-8"), this.secret);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public String now() {
        return this.leftPadding(this.hash(this.secret, this.clock.getCurrentInterval()));
    }

    public boolean verify(String otp) {
        int pastResponse;
        long code = Long.parseLong(otp);
        long currentInterval = this.clock.getCurrentInterval();
        for (int i = pastResponse = Math.max(1, 0); i >= 0; --i) {
            int candidate = this.generate(this.secret, currentInterval - (long)i);
            if ((long)candidate != code) continue;
            return true;
        }
        return false;
    }

    private int generate(String secret, long interval) {
        return this.hash(secret, interval);
    }

    private int hash(String secret, long interval) {
        byte[] hash = new byte[]{};
        try {
            hash = new Hmac(Hash.SHA1, Base32.decode(secret), interval).digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (Base32.DecodingException e) {
            e.printStackTrace();
        }
        return this.bytesToInt(hash);
    }

    private int bytesToInt(byte[] hash) {
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        return binary % Digits.SIX.getValue();
    }

    private String leftPadding(int otp) {
        return String.format("%06d", otp);
    }
}

