/*
 * Decompiled with CFR 0.152.
 */
package org.iatrix.help.wiki.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.rgw.tools.StringTool;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.part.ViewPart;

public class WikiView
extends ViewPart
implements ISaveablePart2 {
    public static final String ID = "org.iatrix.help.wiki.views.WikiView";
    private Browser browser;

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.initialize();
    }

    public void setPage(String page) {
        if (page != null) {
            String wikiName = this.getWikiName(page);
            this.browser.setUrl(String.valueOf(this.getBaseUrl()) + wikiName);
        }
    }

    private String getWikiName(String name) {
        name.replaceAll("[._]+", ".");
        String[] tokens = name.split("[.]");
        int i = 0;
        while (i < tokens.length) {
            tokens[i] = tokens[i].toLowerCase();
            tokens[i] = String.valueOf(tokens[i].substring(0, 1).toUpperCase()) + tokens[i].substring(1);
            ++i;
        }
        String wikiName = StringTool.join((String[])tokens, (String)"");
        return wikiName;
    }

    private String getBaseUrl() {
        return CoreHub.globalCfg.get("org.iatrix.help.wiki/base_url", "http://wiki.elexis.info/");
    }

    private String getStartPage() {
        return CoreHub.globalCfg.get("org.iatrix.help.wiki/start_page", "Hauptseite");
    }

    private String getHandbookUri() {
        return CoreHub.globalCfg.get("org.iatrix.help.wiki/handbook", "https://wiki.elexis.info/Deutsches_Handbuch_3.1");
    }

    public void initialize() {
        this.setPage(this.getStartPage());
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }
}

