/*
 * Decompiled with CFR 0.152.
 */
package org.attoparser.dom;

import java.io.Reader;
import org.attoparser.IMarkupHandler;
import org.attoparser.MarkupParser;
import org.attoparser.ParseException;
import org.attoparser.config.ParseConfiguration;
import org.attoparser.dom.DOMBuilderMarkupHandler;
import org.attoparser.dom.Document;
import org.attoparser.dom.IDOMMarkupParser;

public final class DOMMarkupParser
implements IDOMMarkupParser {
    private final MarkupParser markupParser;

    public DOMMarkupParser(ParseConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration cannot be null");
        }
        this.markupParser = new MarkupParser(configuration);
    }

    public Document parse(String document) throws ParseException {
        return this.parse(null, document);
    }

    public Document parse(char[] document) throws ParseException {
        return this.parse(null, document);
    }

    public Document parse(char[] document, int offset, int len) throws ParseException {
        return this.parse(null, document, offset, len);
    }

    public Document parse(Reader reader) throws ParseException {
        return this.parse(null, reader);
    }

    public Document parse(String documentName, String document) throws ParseException {
        DOMBuilderMarkupHandler domHandler = new DOMBuilderMarkupHandler(documentName);
        this.markupParser.parse(document, (IMarkupHandler)domHandler);
        return domHandler.getDocument();
    }

    public Document parse(String documentName, char[] document) throws ParseException {
        DOMBuilderMarkupHandler domHandler = new DOMBuilderMarkupHandler(documentName);
        this.markupParser.parse(document, (IMarkupHandler)domHandler);
        return domHandler.getDocument();
    }

    public Document parse(String documentName, char[] document, int offset, int len) throws ParseException {
        DOMBuilderMarkupHandler domHandler = new DOMBuilderMarkupHandler(documentName);
        this.markupParser.parse(document, offset, len, domHandler);
        return domHandler.getDocument();
    }

    public Document parse(String documentName, Reader reader) throws ParseException {
        DOMBuilderMarkupHandler domHandler = new DOMBuilderMarkupHandler(documentName);
        this.markupParser.parse(reader, (IMarkupHandler)domHandler);
        return domHandler.getDocument();
    }
}

