/*
 * Decompiled with CFR 0.152.
 */
package info.elexis.server.hapi.fhir;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.interceptor.LoggingInterceptor;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class FhirUtil {
    private static FhirContext context = FhirContext.forDstu3();

    private static IParser getJsonParser() {
        return context.newJsonParser();
    }

    public static IBaseResource getAsResource(String jsonResource) {
        return FhirUtil.getJsonParser().parseResource(jsonResource);
    }

    public static String serializeToString(IBaseResource baseResource) {
        return context.newJsonParser().setPrettyPrint(true).encodeResourceToString(baseResource);
    }

    public static IGenericClient getGenericClient(String theServerBase) {
        LoggingInterceptor loggingInterceptor = new LoggingInterceptor();
        loggingInterceptor.setLogRequestSummary(true);
        loggingInterceptor.setLogRequestBody(true);
        IGenericClient client = context.newRestfulGenericClient(theServerBase);
        client.registerInterceptor((IClientInterceptor)loggingInterceptor);
        return client;
    }
}

