/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.model;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.id.IHasID;
import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.log.InMemoryLogger;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.schematron.pure.model.IPSClonableElement;
import com.phloc.schematron.pure.model.IPSHasForeignElements;
import com.phloc.schematron.pure.model.IPSHasTexts;
import com.phloc.schematron.pure.model.IPSOptionalElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PSDir
implements IPSClonableElement<PSDir>,
IPSOptionalElement,
IPSHasForeignElements,
IPSHasTexts {
    private EDirValue m_eValue;
    private final List<String> m_aContent = new ArrayList<String>();
    private Map<String, String> m_aForeignAttrs;
    private List<IMicroElement> m_aForeignElements;

    @Override
    public boolean isValid(@Nonnull InMemoryLogger inMemoryLogger) {
        if (this.m_aContent.isEmpty()) {
            inMemoryLogger.error((Serializable)((Object)"<dir> has no content"));
            return false;
        }
        return true;
    }

    @Override
    public boolean isMinimal() {
        return true;
    }

    @Override
    public void addForeignElement(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"ForeignElement");
        if (iMicroElement.hasParent()) {
            throw new IllegalArgumentException("ForeignElement already has a parent!");
        }
        if (this.m_aForeignElements == null) {
            this.m_aForeignElements = new ArrayList<IMicroElement>();
        }
        this.m_aForeignElements.add(iMicroElement);
    }

    @Override
    public void addForeignElements(@Nonnull List<IMicroElement> list) {
        ValueEnforcer.notNull(list, (String)"ForeignElements");
        for (IMicroElement iMicroElement : list) {
            this.addForeignElement(iMicroElement);
        }
    }

    @Override
    public boolean hasForeignElements() {
        return this.m_aForeignElements != null && !this.m_aForeignElements.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllForeignElements() {
        return ContainerHelper.newList(this.m_aForeignElements);
    }

    @Override
    public void addForeignAttribute(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"AttrName");
        ValueEnforcer.notNull((Object)string2, (String)"AttrValue");
        if (this.m_aForeignAttrs == null) {
            this.m_aForeignAttrs = new LinkedHashMap<String, String>();
        }
        this.m_aForeignAttrs.put(string, string2);
    }

    @Override
    public void addForeignAttributes(@Nonnull Map<String, String> map) {
        ValueEnforcer.notNull(map, (String)"ForeignAttrs");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addForeignAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasForeignAttributes() {
        return this.m_aForeignAttrs != null && !this.m_aForeignAttrs.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<String, String> getAllForeignAttributes() {
        return ContainerHelper.newOrderedMap(this.m_aForeignAttrs);
    }

    public void setValue(@Nullable EDirValue eDirValue) {
        this.m_eValue = eDirValue;
    }

    @Nullable
    public EDirValue getValue() {
        return this.m_eValue;
    }

    @Override
    public void addText(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Text");
        this.m_aContent.add(string);
    }

    @Override
    public boolean hasAnyText() {
        return !this.m_aContent.isEmpty();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllTexts() {
        return ContainerHelper.newList(this.m_aContent);
    }

    @Nullable
    public String getAsText() {
        return StringHelper.getImploded(this.m_aContent);
    }

    @Override
    @Nonnull
    public IMicroElement getAsMicroElement() {
        MicroElement microElement = new MicroElement("http://purl.oclc.org/dsdl/schematron", "dir");
        if (this.m_eValue != null) {
            microElement.setAttribute("value", this.m_eValue.getID());
        }
        if (this.m_aForeignElements != null) {
            for (IMicroElement object : this.m_aForeignElements) {
                microElement.appendChild((IMicroNode)object.getClone());
            }
        }
        for (String string : this.m_aContent) {
            microElement.appendText((CharSequence)string);
        }
        if (this.m_aForeignAttrs != null) {
            for (Map.Entry entry : this.m_aForeignAttrs.entrySet()) {
                microElement.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return microElement;
    }

    @Nonnull
    public PSDir getClone() {
        PSDir pSDir = new PSDir();
        pSDir.setValue(this.m_eValue);
        for (String string : this.m_aContent) {
            pSDir.addText(string);
        }
        if (this.hasForeignElements()) {
            pSDir.addForeignElements(this.m_aForeignElements);
        }
        if (this.hasForeignAttributes()) {
            pSDir.addForeignAttributes(this.m_aForeignAttrs);
        }
        return pSDir;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("value", (Object)this.m_eValue).append("content", this.m_aContent).appendIfNotNull("foreignAttrs", this.m_aForeignAttrs).appendIfNotNull("foreignElements", this.m_aForeignElements).toString();
    }

    public static enum EDirValue implements IHasID<String>
    {
        LTR("ltr"),
        RTL("rtl");

        private final String m_sID;

        private EDirValue(String string2) {
            this.m_sID = string2;
        }

        @Nonnull
        @Nonempty
        public String getID() {
            return this.m_sID;
        }

        @Nullable
        public static EDirValue getFromIDOrNull(@Nullable String string) {
            return (EDirValue)EnumHelper.getFromIDOrNull(EDirValue.class, (Object)string);
        }
    }
}

