/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.binding.xpath;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.compare.ComparatorStringLongestFirst;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.schematron.pure.binding.xpath.PSXPathQueryBinding;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PSXPathVariables {
    private final Map<String, String> m_aMap = new TreeMap<String, String>((Comparator<String>)new ComparatorStringLongestFirst());

    @Nonnull
    public EChange add(@Nonnull Map.Entry<String, String> entry) {
        return this.add(entry.getKey(), entry.getValue());
    }

    @Nonnull
    public EChange add(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        String string3 = '$' + string;
        if (this.m_aMap.containsKey(string3)) {
            return EChange.UNCHANGED;
        }
        String string4 = this.getAppliedReplacement(string2);
        this.m_aMap.put(string3, string4);
        return EChange.CHANGED;
    }

    @Nullable
    public String getAppliedReplacement(@Nullable String string) {
        return PSXPathQueryBinding.getWithParamTextsReplacedStatic(string, this.m_aMap);
    }

    @Nonnull
    public EChange remove(@Nullable String string) {
        if (StringHelper.hasText((String)string) && this.m_aMap.remove('$' + string) == null) {
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    public void removeAll(@Nullable List<String> list) {
        if (list != null) {
            for (String string : list) {
                this.remove(string);
            }
        }
    }
}

