/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron;

import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.xml.serialize.XMLReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Immutable
public final class SchematronUtils {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SchematronUtils.class);
    private static final SchematronUtils s_aInstance = new SchematronUtils();

    private SchematronUtils() {
    }

    @Nullable
    public static Node getNodeOfSource(@Nonnull Source source) throws SAXException {
        if (source == null) {
            throw new NullPointerException("Source");
        }
        if (source instanceof DOMSource) {
            return ((DOMSource)source).getNode();
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            InputStream inputStream = streamSource.getInputStream();
            if (inputStream != null) {
                Document document = XMLReader.readXMLDOM((InputStream)inputStream);
                if (document == null) {
                    throw new IllegalArgumentException("Failed to read source " + source + " as XML from InputStream " + inputStream);
                }
                return document;
            }
            Reader reader = streamSource.getReader();
            if (reader != null) {
                Document document = XMLReader.readXMLDOM((Reader)reader);
                if (document == null) {
                    throw new IllegalArgumentException("Failed to read source " + source + " as XML from Reader " + reader);
                }
                return document;
            }
            String string = streamSource.getSystemId();
            if (StringHelper.hasText((String)string)) {
                try {
                    URLResource uRLResource = new URLResource(string);
                    Document document = XMLReader.readXMLDOM((IReadableResource)uRLResource);
                    if (document == null) {
                        throw new IllegalArgumentException("Failed to read source " + source + " as XML from SystemID '" + string + "'");
                    }
                    return document;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException("Failed to read source " + source + " as XML from SystemID '" + string + "': " + malformedURLException.getMessage());
                }
            }
            s_aLogger.error("StreamSource contains neither InputStream nor Reader nor SystemID - cannot handle!");
            return null;
        }
        String string = "Can only handle DOMSource and StreamSource - having " + source + " with system ID '" + source.getSystemId() + "'";
        s_aLogger.error(string);
        throw new IllegalArgumentException(string);
    }
}

