/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.callback.IExceptionHandler;
import com.phloc.commons.state.EChange;
import com.phloc.commons.xml.EXMLParserFeature;
import com.phloc.commons.xml.EXMLParserProperty;
import com.phloc.commons.xml.sax.LoggingSAXErrorHandler;
import com.phloc.commons.xml.serialize.XMLLoggingExceptionHandler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

@ThreadSafe
public final class SAXReaderDefaultSettings {
    public static final boolean DEFAULT_REQUIRES_NEW_XML_PARSER_EXPLICITLY = false;
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static EntityResolver s_aDefaultEntityResolver;
    @GuardedBy(value="s_aRWLock")
    private static DTDHandler s_aDefaultDTDHandler;
    @GuardedBy(value="s_aRWLock")
    private static ContentHandler s_aDefaultContentHandler;
    @GuardedBy(value="s_aRWLock")
    private static ErrorHandler s_aDefaultErrorHandler;
    @GuardedBy(value="s_aRWLock")
    private static final EnumMap<EXMLParserProperty, Object> s_aDefaultProperties;
    @GuardedBy(value="s_aRWLock")
    private static final EnumMap<EXMLParserFeature, Boolean> s_aDefaultFeatures;
    @GuardedBy(value="s_aRWLock")
    private static IExceptionHandler<Throwable> s_aDefaultExceptionHandler;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDefaultRequiresNewXMLParserExplicitly;
    private static final SAXReaderDefaultSettings s_aInstance;

    private SAXReaderDefaultSettings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static EntityResolver getEntityResolver() {
        s_aRWLock.readLock().lock();
        try {
            EntityResolver entityResolver = s_aDefaultEntityResolver;
            return entityResolver;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEntityResolver(@Nullable EntityResolver entityResolver) {
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultEntityResolver = entityResolver;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static DTDHandler getDTDHandler() {
        s_aRWLock.readLock().lock();
        try {
            DTDHandler dTDHandler = s_aDefaultDTDHandler;
            return dTDHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDTDHandler(@Nullable DTDHandler dTDHandler) {
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultDTDHandler = dTDHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ContentHandler getContentHandler() {
        s_aRWLock.readLock().lock();
        try {
            ContentHandler contentHandler = s_aDefaultContentHandler;
            return contentHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContentHandler(@Nullable ContentHandler contentHandler) {
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultContentHandler = contentHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ErrorHandler getErrorHandler() {
        s_aRWLock.readLock().lock();
        try {
            ErrorHandler errorHandler = s_aDefaultErrorHandler;
            return errorHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setErrorHandler(@Nullable ErrorHandler errorHandler) {
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultErrorHandler = errorHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nullable
    public static LexicalHandler getLexicalHandler() {
        return (LexicalHandler)SAXReaderDefaultSettings.getPropertyValue(EXMLParserProperty.SAX_LEXICAL_HANDLER);
    }

    public static void setLexicalHandler(@Nullable LexicalHandler lexicalHandler) {
        SAXReaderDefaultSettings.setPropertyValue(EXMLParserProperty.SAX_LEXICAL_HANDLER, lexicalHandler);
    }

    @Nullable
    public static DeclHandler getDeclarationHandler() {
        return (DeclHandler)SAXReaderDefaultSettings.getPropertyValue(EXMLParserProperty.SAX_DECLARATION_HANDLER);
    }

    public static void setDeclarationHandler(@Nullable DeclHandler declHandler) {
        SAXReaderDefaultSettings.setPropertyValue(EXMLParserProperty.SAX_DECLARATION_HANDLER, declHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasAnyProperties() {
        s_aRWLock.readLock().lock();
        try {
            boolean bl = !s_aDefaultProperties.isEmpty();
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Object getPropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        if (eXMLParserProperty == null) {
            return null;
        }
        s_aRWLock.readLock().lock();
        try {
            Object object = s_aDefaultProperties.get(eXMLParserProperty);
            return object;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Map<EXMLParserProperty, Object> getAllPropertyValues() {
        s_aRWLock.readLock().lock();
        try {
            EnumMap<EXMLParserProperty, Object> enumMap = new EnumMap<EXMLParserProperty, Object>(s_aDefaultProperties);
            return enumMap;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPropertyValue(@Nonnull EXMLParserProperty eXMLParserProperty, @Nullable Object object) {
        ValueEnforcer.notNull(eXMLParserProperty, "Property");
        s_aRWLock.writeLock().lock();
        try {
            if (object != null) {
                s_aDefaultProperties.put(eXMLParserProperty, object);
            } else {
                s_aDefaultProperties.remove(eXMLParserProperty);
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPropertyValues(@Nullable Map<EXMLParserProperty, ?> map) {
        if (map != null && !map.isEmpty()) {
            s_aRWLock.writeLock().lock();
            try {
                s_aDefaultProperties.putAll(map);
            }
            finally {
                s_aRWLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange removePropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        if (eXMLParserProperty == null) {
            return EChange.UNCHANGED;
        }
        s_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(s_aDefaultProperties.remove(eXMLParserProperty) != null);
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange removeAllPropertyValues() {
        s_aRWLock.writeLock().lock();
        try {
            if (s_aDefaultProperties.isEmpty()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            s_aDefaultProperties.clear();
            EChange eChange = EChange.CHANGED;
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasAnyFeature() {
        s_aRWLock.readLock().lock();
        try {
            boolean bl = !s_aDefaultFeatures.isEmpty();
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public static Boolean getFeatureValue(@Nullable EXMLParserFeature eXMLParserFeature) {
        if (eXMLParserFeature == null) {
            return null;
        }
        s_aRWLock.readLock().lock();
        try {
            Boolean bl = s_aDefaultFeatures.get(eXMLParserFeature);
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Map<EXMLParserFeature, Boolean> getAllFeatureValues() {
        s_aRWLock.readLock().lock();
        try {
            EnumMap<EXMLParserFeature, Boolean> enumMap = new EnumMap<EXMLParserFeature, Boolean>(s_aDefaultFeatures);
            return enumMap;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, boolean bl) {
        ValueEnforcer.notNull(eXMLParserFeature, "Feature");
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultFeatures.put(eXMLParserFeature, bl);
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, @Nullable Boolean bl) {
        ValueEnforcer.notNull(eXMLParserFeature, "Feature");
        s_aRWLock.writeLock().lock();
        try {
            if (bl == null) {
                s_aDefaultFeatures.remove(eXMLParserFeature);
            } else {
                s_aDefaultFeatures.put(eXMLParserFeature, bl);
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFeatureValues(@Nullable Map<EXMLParserFeature, Boolean> map) {
        if (map != null && !map.isEmpty()) {
            s_aRWLock.writeLock().lock();
            try {
                s_aDefaultFeatures.putAll(map);
            }
            finally {
                s_aRWLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange removeFeature(@Nullable EXMLParserFeature eXMLParserFeature) {
        if (eXMLParserFeature == null) {
            return EChange.UNCHANGED;
        }
        s_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(s_aDefaultFeatures.remove(eXMLParserFeature) != null);
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange removeAllFeatures() {
        s_aRWLock.writeLock().lock();
        try {
            if (s_aDefaultFeatures.isEmpty()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            s_aDefaultFeatures.clear();
            EChange eChange = EChange.CHANGED;
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requiresNewXMLParser() {
        s_aRWLock.readLock().lock();
        try {
            if (s_bDefaultRequiresNewXMLParserExplicitly) {
                boolean bl = true;
                return bl;
            }
            if (!s_aDefaultProperties.isEmpty() || !s_aDefaultFeatures.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = s_aDefaultEntityResolver != null;
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IExceptionHandler<Throwable> getExceptionHandler() {
        s_aRWLock.readLock().lock();
        try {
            IExceptionHandler<Throwable> iExceptionHandler = s_aDefaultExceptionHandler;
            return iExceptionHandler;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExceptionHandler(@Nonnull IExceptionHandler<Throwable> iExceptionHandler) {
        ValueEnforcer.notNull(iExceptionHandler, "ExceptionHandler");
        s_aRWLock.writeLock().lock();
        try {
            s_aDefaultExceptionHandler = iExceptionHandler;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRequiresNewXMLParserExplicitly() {
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_bDefaultRequiresNewXMLParserExplicitly;
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRequiresNewXMLParserExplicitly(boolean bl) {
        s_aRWLock.writeLock().lock();
        try {
            s_bDefaultRequiresNewXMLParserExplicitly = bl;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    static {
        s_aDefaultErrorHandler = LoggingSAXErrorHandler.getInstance();
        s_aDefaultProperties = new EnumMap(EXMLParserProperty.class);
        s_aDefaultFeatures = new EnumMap(EXMLParserFeature.class);
        s_aDefaultExceptionHandler = new XMLLoggingExceptionHandler();
        s_bDefaultRequiresNewXMLParserExplicitly = false;
        s_aInstance = new SAXReaderDefaultSettings();
    }
}

