/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.ICloneable;
import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.callback.IExceptionHandler;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.EXMLParserFeature;
import com.phloc.commons.xml.EXMLParserProperty;
import com.phloc.commons.xml.serialize.DOMReaderDefaultSettings;
import com.phloc.commons.xml.serialize.IDOMReaderSettings;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

@NotThreadSafe
public class DOMReaderSettings
implements ICloneable<DOMReaderSettings>,
IDOMReaderSettings {
    private static final Logger s_aLogger = LoggerFactory.getLogger(DOMReaderSettings.class);
    private boolean m_bNamespaceAware;
    private boolean m_bValidating;
    private boolean m_bIgnoringElementContentWhitespace;
    private boolean m_bExpandEntityReferences;
    private boolean m_bIgnoringComments;
    private boolean m_bCoalescing;
    private Schema m_aSchema;
    private boolean m_bXIncludeAware;
    private final EnumMap<EXMLParserProperty, Object> m_aProperties = new EnumMap(EXMLParserProperty.class);
    private final EnumMap<EXMLParserFeature, Boolean> m_aFeatures = new EnumMap(EXMLParserFeature.class);
    private EntityResolver m_aEntityResolver;
    private ErrorHandler m_aErrorHandler;
    private IExceptionHandler<Throwable> m_aExceptionHandler;
    private boolean m_bRequiresNewXMLParserExplicitly;

    public DOMReaderSettings() {
        this.setNamespaceAware(DOMReaderDefaultSettings.isNamespaceAware());
        this.setValidating(DOMReaderDefaultSettings.isValidating());
        this.setIgnoringElementContentWhitespace(DOMReaderDefaultSettings.isIgnoringElementContentWhitespace());
        this.setExpandEntityReferences(DOMReaderDefaultSettings.isExpandEntityReferences());
        this.setIgnoringComments(DOMReaderDefaultSettings.isIgnoringComments());
        this.setCoalescing(DOMReaderDefaultSettings.isCoalescing());
        this.setSchema(DOMReaderDefaultSettings.getSchema());
        this.setXIncludeAware(DOMReaderDefaultSettings.isXIncludeAware());
        this.setPropertyValues(DOMReaderDefaultSettings.getAllPropertyValues());
        this.setFeatureValues(DOMReaderDefaultSettings.getAllFeatureValues());
        this.setEntityResolver(DOMReaderDefaultSettings.getEntityResolver());
        this.setErrorHandler(DOMReaderDefaultSettings.getErrorHandler());
        this.setExceptionHandler(DOMReaderDefaultSettings.getExceptionHandler());
        this.setRequiresNewXMLParserExplicitly(DOMReaderDefaultSettings.isRequiresNewXMLParserExplicitly());
    }

    public DOMReaderSettings(@Nonnull IDOMReaderSettings iDOMReaderSettings) {
        ValueEnforcer.notNull(iDOMReaderSettings, "Other");
        this.setNamespaceAware(iDOMReaderSettings.isNamespaceAware());
        this.setValidating(iDOMReaderSettings.isValidating());
        this.setIgnoringElementContentWhitespace(iDOMReaderSettings.isIgnoringElementContentWhitespace());
        this.setExpandEntityReferences(iDOMReaderSettings.isExpandEntityReferences());
        this.setIgnoringComments(iDOMReaderSettings.isIgnoringComments());
        this.setCoalescing(iDOMReaderSettings.isCoalescing());
        this.setSchema(iDOMReaderSettings.getSchema());
        this.setXIncludeAware(iDOMReaderSettings.isXIncludeAware());
        this.setPropertyValues(iDOMReaderSettings.getAllPropertyValues());
        this.setFeatureValues(iDOMReaderSettings.getAllFeatureValues());
        this.setEntityResolver(iDOMReaderSettings.getEntityResolver());
        this.setErrorHandler(iDOMReaderSettings.getErrorHandler());
        this.setExceptionHandler(iDOMReaderSettings.getExceptionHandler());
        this.setRequiresNewXMLParserExplicitly(iDOMReaderSettings.isRequiresNewXMLParserExplicitly());
    }

    @Override
    public boolean isNamespaceAware() {
        return this.m_bNamespaceAware;
    }

    @Nonnull
    public final DOMReaderSettings setNamespaceAware(boolean bl) {
        this.m_bNamespaceAware = bl;
        return this;
    }

    @Override
    public boolean isValidating() {
        return this.m_bValidating;
    }

    @Nonnull
    public final DOMReaderSettings setValidating(boolean bl) {
        this.m_bValidating = bl;
        return this;
    }

    @Override
    public boolean isIgnoringElementContentWhitespace() {
        return this.m_bIgnoringElementContentWhitespace;
    }

    @Nonnull
    public final DOMReaderSettings setIgnoringElementContentWhitespace(boolean bl) {
        this.m_bIgnoringElementContentWhitespace = bl;
        return this;
    }

    @Override
    public boolean isExpandEntityReferences() {
        return this.m_bExpandEntityReferences;
    }

    @Nonnull
    public final DOMReaderSettings setExpandEntityReferences(boolean bl) {
        this.m_bExpandEntityReferences = bl;
        return this;
    }

    @Override
    public boolean isIgnoringComments() {
        return this.m_bIgnoringComments;
    }

    @Nonnull
    public final DOMReaderSettings setIgnoringComments(boolean bl) {
        this.m_bIgnoringComments = bl;
        return this;
    }

    @Override
    public boolean isCoalescing() {
        return this.m_bCoalescing;
    }

    @Nonnull
    public final DOMReaderSettings setCoalescing(boolean bl) {
        this.m_bCoalescing = bl;
        return this;
    }

    @Override
    @Nullable
    public Schema getSchema() {
        return this.m_aSchema;
    }

    @Nonnull
    public final DOMReaderSettings setSchema(@Nullable Schema schema) {
        this.m_aSchema = schema;
        return this;
    }

    @Override
    public boolean isXIncludeAware() {
        return this.m_bXIncludeAware;
    }

    @Nonnull
    public final DOMReaderSettings setXIncludeAware(boolean bl) {
        this.m_bXIncludeAware = bl;
        return this;
    }

    @Override
    public boolean hasAnyProperties() {
        return !this.m_aProperties.isEmpty();
    }

    @Override
    @Nullable
    public Object getPropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        return eXMLParserProperty == null ? null : this.m_aProperties.get(eXMLParserProperty);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<EXMLParserProperty, Object> getAllPropertyValues() {
        return new EnumMap<EXMLParserProperty, Object>(this.m_aProperties);
    }

    @Nonnull
    public final DOMReaderSettings setPropertyValue(@Nonnull EXMLParserProperty eXMLParserProperty, @Nullable Object object) {
        ValueEnforcer.notNull(eXMLParserProperty, "Property");
        if (object != null && eXMLParserProperty.getValueClass() != null && !eXMLParserProperty.getValueClass().isAssignableFrom(object.getClass())) {
            s_aLogger.warn("Setting the XML parser property '" + eXMLParserProperty + "' to a value of " + object.getClass() + " will most likely not be interpreted!");
        }
        if (object != null) {
            this.m_aProperties.put(eXMLParserProperty, object);
        } else {
            this.m_aProperties.remove(eXMLParserProperty);
        }
        return this;
    }

    @Nonnull
    public final DOMReaderSettings setPropertyValues(@Nullable Map<EXMLParserProperty, ?> map) {
        if (map != null) {
            this.m_aProperties.putAll(map);
        }
        return this;
    }

    @Nonnull
    public final EChange removePropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        return EChange.valueOf(eXMLParserProperty != null && this.m_aProperties.remove(eXMLParserProperty) != null);
    }

    @Nonnull
    public final EChange removeAllPropertyValues() {
        if (this.m_aProperties.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aProperties.clear();
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public Locale getLocale() {
        return (Locale)this.getPropertyValue(EXMLParserProperty.GENERAL_LOCALE);
    }

    public DOMReaderSettings setLocale(@Nullable Locale locale) {
        return this.setPropertyValue(EXMLParserProperty.GENERAL_LOCALE, locale);
    }

    @Override
    public boolean hasAnyFeature() {
        return !this.m_aFeatures.isEmpty();
    }

    @Override
    @Nullable
    public Boolean getFeatureValue(@Nullable EXMLParserFeature eXMLParserFeature) {
        return eXMLParserFeature == null ? null : this.m_aFeatures.get(eXMLParserFeature);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<EXMLParserFeature, Boolean> getAllFeatureValues() {
        return new EnumMap<EXMLParserFeature, Boolean>(this.m_aFeatures);
    }

    @Nonnull
    public final DOMReaderSettings setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, boolean bl) {
        ValueEnforcer.notNull(eXMLParserFeature, "Feature");
        this.m_aFeatures.put(eXMLParserFeature, bl);
        return this;
    }

    @Nonnull
    public final DOMReaderSettings setFeatureValue(@Nonnull EXMLParserFeature eXMLParserFeature, @Nullable Boolean bl) {
        ValueEnforcer.notNull(eXMLParserFeature, "Feature");
        if (bl == null) {
            this.m_aFeatures.remove(eXMLParserFeature);
        } else {
            this.m_aFeatures.put(eXMLParserFeature, bl);
        }
        return this;
    }

    @Nonnull
    public final DOMReaderSettings setFeatureValues(@Nullable Map<EXMLParserFeature, Boolean> map) {
        if (map != null) {
            this.m_aFeatures.putAll(map);
        }
        return this;
    }

    @Nonnull
    public final EChange removeFeature(@Nullable EXMLParserFeature eXMLParserFeature) {
        return EChange.valueOf(eXMLParserFeature != null && this.m_aFeatures.remove(eXMLParserFeature) != null);
    }

    @Nonnull
    public final EChange removeAllFeatures() {
        if (this.m_aFeatures.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aFeatures.clear();
        return EChange.CHANGED;
    }

    @Override
    public boolean requiresNewXMLParser() {
        if (this.m_bRequiresNewXMLParserExplicitly) {
            return true;
        }
        if (!(this.m_bNamespaceAware && !this.m_bValidating && !this.m_bIgnoringElementContentWhitespace && this.m_bExpandEntityReferences && this.m_bIgnoringComments && this.m_bCoalescing && this.m_aSchema == null && !this.m_bXIncludeAware && this.m_aProperties.isEmpty() && this.m_aFeatures.isEmpty())) {
            return true;
        }
        return this.m_aEntityResolver != null;
    }

    @Override
    @Nullable
    public EntityResolver getEntityResolver() {
        return this.m_aEntityResolver;
    }

    @Nonnull
    public final DOMReaderSettings setEntityResolver(@Nullable EntityResolver entityResolver) {
        this.m_aEntityResolver = entityResolver;
        return this;
    }

    @Override
    @Nullable
    public ErrorHandler getErrorHandler() {
        return this.m_aErrorHandler;
    }

    @Nonnull
    public final DOMReaderSettings setErrorHandler(@Nullable ErrorHandler errorHandler) {
        this.m_aErrorHandler = errorHandler;
        return this;
    }

    @Override
    @Nonnull
    public IExceptionHandler<Throwable> getExceptionHandler() {
        return this.m_aExceptionHandler;
    }

    @Nonnull
    public final DOMReaderSettings setExceptionHandler(@Nonnull IExceptionHandler<Throwable> iExceptionHandler) {
        ValueEnforcer.notNull(iExceptionHandler, "ExceptionHandler");
        this.m_aExceptionHandler = iExceptionHandler;
        return this;
    }

    @Override
    public boolean isRequiresNewXMLParserExplicitly() {
        return this.m_bRequiresNewXMLParserExplicitly;
    }

    @Nonnull
    public final DOMReaderSettings setRequiresNewXMLParserExplicitly(boolean bl) {
        this.m_bRequiresNewXMLParserExplicitly = bl;
        return this;
    }

    @Override
    @Nonnull
    public DOMReaderSettings getClone() {
        return new DOMReaderSettings(this);
    }

    @Override
    public void applyToDocumentBuilderFactory(@Nonnull DocumentBuilderFactory documentBuilderFactory) {
        ValueEnforcer.notNull(documentBuilderFactory, "DocumentBuilderFactory");
        documentBuilderFactory.setNamespaceAware(this.isNamespaceAware());
        documentBuilderFactory.setValidating(this.isValidating());
        documentBuilderFactory.setIgnoringElementContentWhitespace(this.isIgnoringElementContentWhitespace());
        documentBuilderFactory.setExpandEntityReferences(this.isExpandEntityReferences());
        documentBuilderFactory.setIgnoringComments(this.isIgnoringComments());
        documentBuilderFactory.setCoalescing(this.isCoalescing());
        try {
            documentBuilderFactory.setSchema(this.getSchema());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            s_aLogger.warn("DocumentBuilderFactory does not support XML Schema: " + unsupportedOperationException.getMessage());
        }
        try {
            documentBuilderFactory.setXIncludeAware(this.isXIncludeAware());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            s_aLogger.warn("DocumentBuilderFactory does not support XInclude setting: " + unsupportedOperationException.getMessage());
        }
        if (this.hasAnyProperties()) {
            for (Map.Entry<Enum, Object> entry : this.getAllPropertyValues().entrySet()) {
                ((EXMLParserProperty)entry.getKey()).applyTo(documentBuilderFactory, entry.getValue());
            }
        }
        if (this.hasAnyFeature()) {
            for (Map.Entry<Enum, Object> entry : this.getAllFeatureValues().entrySet()) {
                ((EXMLParserFeature)entry.getKey()).applyTo(documentBuilderFactory, (boolean)((Boolean)entry.getValue()));
            }
        }
    }

    @Override
    public void applyToDocumentBuilder(@Nonnull DocumentBuilder documentBuilder) {
        ValueEnforcer.notNull(documentBuilder, "DocumentBuilder");
        documentBuilder.setErrorHandler(this.getErrorHandler());
        documentBuilder.setEntityResolver(this.getEntityResolver());
    }

    public String toString() {
        return new ToStringGenerator(this).append("namespaceAware", this.m_bNamespaceAware).append("validating", this.m_bValidating).append("ignoringElementContentWhitespace", this.m_bIgnoringElementContentWhitespace).append("expandEntityReferences", this.m_bExpandEntityReferences).append("ignoringComments", this.m_bIgnoringComments).append("coalescing", this.m_bCoalescing).append("schema", this.m_aSchema).append("XIncludeAware", this.m_bXIncludeAware).append("properties", this.m_aProperties).append("features", this.m_aFeatures).append("entityResolver", this.m_aEntityResolver).append("errorHandler", this.m_aErrorHandler).append("exceptionHandler", this.m_aExceptionHandler).append("requiresNewXMLParserExplicitly", this.m_bRequiresNewXMLParserExplicitly).toString();
    }
}

