/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.filter.ISerializableFilter;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.XMLHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Element;

@NotThreadSafe
public final class FilterElementWithNamespaceAndLocalName
implements ISerializableFilter<Element> {
    private final String m_sNamespaceURI;
    private final String m_sLocalName;

    public FilterElementWithNamespaceAndLocalName(@Nullable String string, @Nonnull @Nonempty String string2) {
        this.m_sNamespaceURI = string;
        this.m_sLocalName = ValueEnforcer.notEmpty(string2, "LocalName");
    }

    @Override
    public boolean matchesFilter(@Nullable Element element) {
        return element != null && XMLHelper.hasNamespaceURI(element, this.m_sNamespaceURI) && element.getLocalName().equals(this.m_sLocalName);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FilterElementWithNamespaceAndLocalName)) {
            return false;
        }
        FilterElementWithNamespaceAndLocalName filterElementWithNamespaceAndLocalName = (FilterElementWithNamespaceAndLocalName)object;
        return EqualsUtils.equals(this.m_sNamespaceURI, filterElementWithNamespaceAndLocalName.m_sNamespaceURI) && this.m_sLocalName.equals(filterElementWithNamespaceAndLocalName.m_sLocalName);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sNamespaceURI).append(this.m_sLocalName).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("namespaceURI", this.m_sNamespaceURI).append("localName", this.m_sLocalName).toString();
    }
}

