/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.url;

import com.phloc.commons.ICloneable;
import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.url.AbstractSimpleURL;
import com.phloc.commons.url.IURLData;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleURL
extends AbstractSimpleURL
implements ICloneable<SimpleURL> {
    public SimpleURL() {
    }

    public SimpleURL(@Nonnull String string) {
        super(string);
    }

    public SimpleURL(@Nonnull String string, @Nullable Map<String, String> map) {
        super(string, map);
    }

    public SimpleURL(@Nonnull String string, @Nullable Map<String, String> map, @Nullable String string2) {
        super(string, map, string2);
    }

    public SimpleURL(@Nonnull IURLData iURLData) {
        super(iURLData);
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string) {
        return this.add(string, "");
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty(string, "Key");
        ValueEnforcer.notNull(string2, "Value");
        if (this.m_aParams == null) {
            this.m_aParams = new LinkedHashMap();
        }
        this.m_aParams.put(string, string2);
        return this;
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string, int n) {
        return this.add(string, Integer.toString(n));
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string, long l) {
        return this.add(string, Long.toString(l));
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string, @Nonnull BigInteger bigInteger) {
        return this.add(string, bigInteger.toString());
    }

    @Nonnull
    public SimpleURL addIfNonNull(@Nonnull @Nonempty String string, @Nullable String string2) {
        if (string2 != null) {
            this.add(string, string2);
        }
        return this;
    }

    @Nonnull
    public SimpleURL addAll(@Nullable Map<String, String> map) {
        if (ContainerHelper.isNotEmpty(map)) {
            if (this.m_aParams == null) {
                this.m_aParams = new LinkedHashMap();
            }
            this.m_aParams.putAll(map);
        }
        return this;
    }

    @Nonnull
    public SimpleURL remove(@Nullable String string) {
        if (this.m_aParams != null) {
            this.m_aParams.remove(string);
        }
        return this;
    }

    @Nonnull
    public SimpleURL setAnchor(@Nullable String string) {
        this.m_sAnchor = string;
        return this;
    }

    @Override
    @Nonnull
    public SimpleURL getClone() {
        return new SimpleURL(this);
    }
}

