/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.stats;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.jmx.JMXUtils;
import com.phloc.commons.stats.IStatisticsHandlerCache;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.IStatisticsHandlerKeyedCounter;
import com.phloc.commons.stats.IStatisticsHandlerKeyedSize;
import com.phloc.commons.stats.IStatisticsHandlerKeyedTimer;
import com.phloc.commons.stats.IStatisticsHandlerSize;
import com.phloc.commons.stats.IStatisticsHandlerTimer;
import com.phloc.commons.stats.StatisticsHandlerCache;
import com.phloc.commons.stats.StatisticsHandlerCounter;
import com.phloc.commons.stats.StatisticsHandlerKeyedCounter;
import com.phloc.commons.stats.StatisticsHandlerKeyedSize;
import com.phloc.commons.stats.StatisticsHandlerKeyedTimer;
import com.phloc.commons.stats.StatisticsHandlerSize;
import com.phloc.commons.stats.StatisticsHandlerTimer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class StatisticsManager {
    public static final boolean DEFAULT_JMX_ENABLED = false;
    private static final AtomicBoolean s_aJMXEnabled = new AtomicBoolean(false);
    private static final ReadWriteLock s_aRWLockCache = new ReentrantReadWriteLock();
    private static final ReadWriteLock s_aRWLockTimer = new ReentrantReadWriteLock();
    private static final ReadWriteLock s_aRWLockKeyedTimer = new ReentrantReadWriteLock();
    private static final ReadWriteLock s_aRWLockSize = new ReentrantReadWriteLock();
    private static final ReadWriteLock s_aRWLockKeyedSize = new ReentrantReadWriteLock();
    private static final ReadWriteLock s_aRWLockCounter = new ReentrantReadWriteLock();
    private static final ReadWriteLock s_aRWLockKeyedCounter = new ReentrantReadWriteLock();
    private static final Map<String, StatisticsHandlerCache> s_aHdlCache = new HashMap<String, StatisticsHandlerCache>();
    private static final Map<String, StatisticsHandlerTimer> s_aHdlTimer = new HashMap<String, StatisticsHandlerTimer>();
    private static final Map<String, StatisticsHandlerKeyedTimer> s_aHdlKeyedTimer = new HashMap<String, StatisticsHandlerKeyedTimer>();
    private static final Map<String, StatisticsHandlerSize> s_aHdlSize = new HashMap<String, StatisticsHandlerSize>();
    private static final Map<String, StatisticsHandlerKeyedSize> s_aHdlKeyedSize = new HashMap<String, StatisticsHandlerKeyedSize>();
    private static final Map<String, StatisticsHandlerCounter> s_aHdlCounter = new HashMap<String, StatisticsHandlerCounter>();
    private static final Map<String, StatisticsHandlerKeyedCounter> s_aHdlKeyedCounter = new HashMap<String, StatisticsHandlerKeyedCounter>();
    private static final StatisticsManager s_aInstance = new StatisticsManager();

    private StatisticsManager() {
    }

    public static boolean isJMXEnabled() {
        return s_aJMXEnabled.get();
    }

    public static void setJMXEnabled(boolean bl) {
        s_aJMXEnabled.set(bl);
    }

    @Nonnull
    public static IStatisticsHandlerCache getCacheHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getCacheHandler(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IStatisticsHandlerCache getCacheHandler(@Nonnull @Nonempty String string) {
        StatisticsHandlerCache statisticsHandlerCache;
        ValueEnforcer.notEmpty(string, "Name");
        s_aRWLockCache.readLock().lock();
        try {
            statisticsHandlerCache = s_aHdlCache.get(string);
        }
        finally {
            s_aRWLockCache.readLock().unlock();
        }
        if (statisticsHandlerCache == null) {
            s_aRWLockCache.writeLock().lock();
            try {
                statisticsHandlerCache = s_aHdlCache.get(string);
                if (statisticsHandlerCache == null) {
                    statisticsHandlerCache = new StatisticsHandlerCache();
                    if (StatisticsManager.isJMXEnabled()) {
                        JMXUtils.exposeMBeanWithAutoName(statisticsHandlerCache, string);
                    }
                    s_aHdlCache.put(string, statisticsHandlerCache);
                }
            }
            finally {
                s_aRWLockCache.writeLock().unlock();
            }
        }
        return statisticsHandlerCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllCacheHandler() {
        s_aRWLockCache.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aHdlCache.keySet());
            return set;
        }
        finally {
            s_aRWLockCache.readLock().unlock();
        }
    }

    @Nonnull
    public static IStatisticsHandlerTimer getTimerHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getTimerHandler(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IStatisticsHandlerTimer getTimerHandler(@Nonnull @Nonempty String string) {
        StatisticsHandlerTimer statisticsHandlerTimer;
        ValueEnforcer.notEmpty(string, "Name");
        s_aRWLockTimer.readLock().lock();
        try {
            statisticsHandlerTimer = s_aHdlTimer.get(string);
        }
        finally {
            s_aRWLockTimer.readLock().unlock();
        }
        if (statisticsHandlerTimer == null) {
            s_aRWLockTimer.writeLock().lock();
            try {
                statisticsHandlerTimer = s_aHdlTimer.get(string);
                if (statisticsHandlerTimer == null) {
                    statisticsHandlerTimer = new StatisticsHandlerTimer();
                    if (StatisticsManager.isJMXEnabled()) {
                        JMXUtils.exposeMBeanWithAutoName(statisticsHandlerTimer, string);
                    }
                    s_aHdlTimer.put(string, statisticsHandlerTimer);
                }
            }
            finally {
                s_aRWLockTimer.writeLock().unlock();
            }
        }
        return statisticsHandlerTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllTimerHandler() {
        s_aRWLockTimer.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aHdlTimer.keySet());
            return set;
        }
        finally {
            s_aRWLockTimer.readLock().unlock();
        }
    }

    @Nonnull
    public static IStatisticsHandlerKeyedTimer getKeyedTimerHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getKeyedTimerHandler(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IStatisticsHandlerKeyedTimer getKeyedTimerHandler(@Nonnull @Nonempty String string) {
        StatisticsHandlerKeyedTimer statisticsHandlerKeyedTimer;
        ValueEnforcer.notEmpty(string, "Name");
        s_aRWLockKeyedTimer.readLock().lock();
        try {
            statisticsHandlerKeyedTimer = s_aHdlKeyedTimer.get(string);
        }
        finally {
            s_aRWLockKeyedTimer.readLock().unlock();
        }
        if (statisticsHandlerKeyedTimer == null) {
            s_aRWLockKeyedTimer.writeLock().lock();
            try {
                statisticsHandlerKeyedTimer = s_aHdlKeyedTimer.get(string);
                if (statisticsHandlerKeyedTimer == null) {
                    statisticsHandlerKeyedTimer = new StatisticsHandlerKeyedTimer();
                    if (StatisticsManager.isJMXEnabled()) {
                        JMXUtils.exposeMBeanWithAutoName(statisticsHandlerKeyedTimer, string);
                    }
                    s_aHdlKeyedTimer.put(string, statisticsHandlerKeyedTimer);
                }
            }
            finally {
                s_aRWLockKeyedTimer.writeLock().unlock();
            }
        }
        return statisticsHandlerKeyedTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllKeyedTimerHandler() {
        s_aRWLockKeyedTimer.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aHdlKeyedTimer.keySet());
            return set;
        }
        finally {
            s_aRWLockKeyedTimer.readLock().unlock();
        }
    }

    @Nonnull
    public static IStatisticsHandlerSize getSizeHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getSizeHandler(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IStatisticsHandlerSize getSizeHandler(@Nonnull @Nonempty String string) {
        StatisticsHandlerSize statisticsHandlerSize;
        ValueEnforcer.notEmpty(string, "Name");
        s_aRWLockSize.readLock().lock();
        try {
            statisticsHandlerSize = s_aHdlSize.get(string);
        }
        finally {
            s_aRWLockSize.readLock().unlock();
        }
        if (statisticsHandlerSize == null) {
            s_aRWLockSize.writeLock().lock();
            try {
                statisticsHandlerSize = s_aHdlSize.get(string);
                if (statisticsHandlerSize == null) {
                    statisticsHandlerSize = new StatisticsHandlerSize();
                    if (StatisticsManager.isJMXEnabled()) {
                        JMXUtils.exposeMBeanWithAutoName(statisticsHandlerSize, string);
                    }
                    s_aHdlSize.put(string, statisticsHandlerSize);
                }
            }
            finally {
                s_aRWLockSize.writeLock().unlock();
            }
        }
        return statisticsHandlerSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllSizeHandler() {
        s_aRWLockSize.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aHdlSize.keySet());
            return set;
        }
        finally {
            s_aRWLockSize.readLock().unlock();
        }
    }

    @Nonnull
    public static IStatisticsHandlerKeyedSize getKeyedSizeHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getKeyedSizeHandler(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IStatisticsHandlerKeyedSize getKeyedSizeHandler(@Nonnull @Nonempty String string) {
        StatisticsHandlerKeyedSize statisticsHandlerKeyedSize;
        ValueEnforcer.notEmpty(string, "Name");
        s_aRWLockKeyedSize.readLock().lock();
        try {
            statisticsHandlerKeyedSize = s_aHdlKeyedSize.get(string);
        }
        finally {
            s_aRWLockKeyedSize.readLock().unlock();
        }
        if (statisticsHandlerKeyedSize == null) {
            s_aRWLockKeyedSize.writeLock().lock();
            try {
                statisticsHandlerKeyedSize = s_aHdlKeyedSize.get(string);
                if (statisticsHandlerKeyedSize == null) {
                    statisticsHandlerKeyedSize = new StatisticsHandlerKeyedSize();
                    if (StatisticsManager.isJMXEnabled()) {
                        JMXUtils.exposeMBeanWithAutoName(statisticsHandlerKeyedSize, string);
                    }
                    s_aHdlKeyedSize.put(string, statisticsHandlerKeyedSize);
                }
            }
            finally {
                s_aRWLockKeyedSize.writeLock().unlock();
            }
        }
        return statisticsHandlerKeyedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllKeyedSizeHandler() {
        s_aRWLockKeyedSize.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aHdlKeyedSize.keySet());
            return set;
        }
        finally {
            s_aRWLockKeyedSize.readLock().unlock();
        }
    }

    @Nonnull
    public static IStatisticsHandlerCounter getCounterHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getCounterHandler(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IStatisticsHandlerCounter getCounterHandler(@Nonnull @Nonempty String string) {
        StatisticsHandlerCounter statisticsHandlerCounter;
        ValueEnforcer.notEmpty(string, "Name");
        s_aRWLockCounter.readLock().lock();
        try {
            statisticsHandlerCounter = s_aHdlCounter.get(string);
        }
        finally {
            s_aRWLockCounter.readLock().unlock();
        }
        if (statisticsHandlerCounter == null) {
            s_aRWLockCounter.writeLock().lock();
            try {
                statisticsHandlerCounter = s_aHdlCounter.get(string);
                if (statisticsHandlerCounter == null) {
                    statisticsHandlerCounter = new StatisticsHandlerCounter();
                    if (StatisticsManager.isJMXEnabled()) {
                        JMXUtils.exposeMBeanWithAutoName(statisticsHandlerCounter, string);
                    }
                    s_aHdlCounter.put(string, statisticsHandlerCounter);
                }
            }
            finally {
                s_aRWLockCounter.writeLock().unlock();
            }
        }
        return statisticsHandlerCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllCounterHandler() {
        s_aRWLockCounter.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aHdlCounter.keySet());
            return set;
        }
        finally {
            s_aRWLockCounter.readLock().unlock();
        }
    }

    @Nonnull
    public static IStatisticsHandlerKeyedCounter getKeyedCounterHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getKeyedCounterHandler(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IStatisticsHandlerKeyedCounter getKeyedCounterHandler(@Nonnull @Nonempty String string) {
        StatisticsHandlerKeyedCounter statisticsHandlerKeyedCounter;
        ValueEnforcer.notEmpty(string, "Name");
        s_aRWLockKeyedCounter.readLock().lock();
        try {
            statisticsHandlerKeyedCounter = s_aHdlKeyedCounter.get(string);
        }
        finally {
            s_aRWLockKeyedCounter.readLock().unlock();
        }
        if (statisticsHandlerKeyedCounter == null) {
            s_aRWLockKeyedCounter.writeLock().lock();
            try {
                statisticsHandlerKeyedCounter = s_aHdlKeyedCounter.get(string);
                if (statisticsHandlerKeyedCounter == null) {
                    statisticsHandlerKeyedCounter = new StatisticsHandlerKeyedCounter();
                    if (StatisticsManager.isJMXEnabled()) {
                        JMXUtils.exposeMBeanWithAutoName(statisticsHandlerKeyedCounter, string);
                    }
                    s_aHdlKeyedCounter.put(string, statisticsHandlerKeyedCounter);
                }
            }
            finally {
                s_aRWLockKeyedCounter.writeLock().unlock();
            }
        }
        return statisticsHandlerKeyedCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllKeyedCounterHandler() {
        s_aRWLockKeyedCounter.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aHdlKeyedCounter.keySet());
            return set;
        }
        finally {
            s_aRWLockKeyedCounter.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        s_aRWLockCache.writeLock().lock();
        try {
            s_aHdlCache.clear();
        }
        finally {
            s_aRWLockCache.writeLock().unlock();
        }
        s_aRWLockTimer.writeLock().lock();
        try {
            s_aHdlTimer.clear();
        }
        finally {
            s_aRWLockTimer.writeLock().unlock();
        }
        s_aRWLockKeyedTimer.writeLock().lock();
        try {
            s_aHdlKeyedTimer.clear();
        }
        finally {
            s_aRWLockKeyedTimer.writeLock().unlock();
        }
        s_aRWLockSize.writeLock().lock();
        try {
            s_aHdlSize.clear();
        }
        finally {
            s_aRWLockSize.writeLock().unlock();
        }
        s_aRWLockKeyedSize.writeLock().lock();
        try {
            s_aHdlKeyedSize.clear();
        }
        finally {
            s_aRWLockKeyedSize.writeLock().unlock();
        }
        s_aRWLockCounter.writeLock().lock();
        try {
            s_aHdlCounter.clear();
        }
        finally {
            s_aRWLockCounter.writeLock().unlock();
        }
        s_aRWLockKeyedCounter.writeLock().lock();
        try {
            s_aHdlKeyedCounter.clear();
        }
        finally {
            s_aRWLockKeyedCounter.writeLock().unlock();
        }
    }
}

