/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.stats;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.stats.IStatisticsHandlerNumeric;
import java.math.BigInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
abstract class AbstractStatisticsHandlerNumeric
implements IStatisticsHandlerNumeric {
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private int m_nInvocationCount = 0;
    private long m_nMin = -1L;
    private long m_nMax = -1L;
    private BigInteger m_aSum = BigInteger.ZERO;

    AbstractStatisticsHandlerNumeric() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnegative
    public final int getInvocationCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_nInvocationCount;
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addValue(long l) {
        this.m_aRWLock.writeLock().lock();
        try {
            ++this.m_nInvocationCount;
            if (this.m_nMin == -1L || l < this.m_nMin) {
                this.m_nMin = l;
            }
            if (this.m_nMax == -1L || l > this.m_nMax) {
                this.m_nMax = l;
            }
            this.m_aSum = this.m_aSum.add(BigInteger.valueOf(l));
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public final BigInteger getSum() {
        this.m_aRWLock.readLock().lock();
        try {
            BigInteger bigInteger = this.m_aSum;
            return bigInteger;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForSigned
    public final long getMin() {
        this.m_aRWLock.readLock().lock();
        try {
            long l = this.m_nMin;
            return l;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForSigned
    public final long getAverage() {
        this.m_aRWLock.readLock().lock();
        try {
            if (this.m_nInvocationCount == 0) {
                long l = -1L;
                return l;
            }
            long l = this.m_aSum.divide(BigInteger.valueOf(this.m_nInvocationCount)).longValue();
            return l;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForSigned
    public long getMax() {
        this.m_aRWLock.readLock().lock();
        try {
            long l = this.m_nMax;
            return l;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        return "invocations=" + this.getInvocationCount() + ";sum=" + this.getSum() + ";min=" + this.getMin() + ";avg=" + this.getAverage() + ";max=" + this.getMax();
    }
}

