/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.serialize;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.streams.NonBlockingStringWriter;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.serialize.MicroSerializer;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.stats.IStatisticsHandlerSize;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.xml.serialize.IXMLWriterSettings;
import com.phloc.commons.xml.serialize.XMLWriterSettings;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class MicroWriter {
    private static final Logger s_aLogger = LoggerFactory.getLogger(MicroWriter.class);
    private static final IStatisticsHandlerSize s_aSizeHdl = StatisticsManager.getSizeHandler(MicroWriter.class);
    private static final MicroWriter s_aInstance = new MicroWriter();

    private MicroWriter() {
    }

    @Nonnull
    public static ESuccess writeToFile(@Nonnull IMicroNode iMicroNode, @Nonnull File file) {
        return MicroWriter.writeToFile(iMicroNode, file, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    @Nonnull
    public static ESuccess writeToFile(@Nonnull IMicroNode iMicroNode, @Nonnull File file, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull(file, "File");
        OutputStream outputStream = FileUtils.getOutputStream(file);
        if (outputStream == null) {
            return ESuccess.FAILURE;
        }
        return MicroWriter.writeToStream(iMicroNode, outputStream, iXMLWriterSettings);
    }

    @Nonnull
    public static ESuccess writeToStream(@Nonnull IMicroNode iMicroNode, @Nonnull @WillClose OutputStream outputStream) {
        return MicroWriter.writeToStream(iMicroNode, outputStream, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeToStream(@Nonnull IMicroNode iMicroNode, @Nonnull @WillClose OutputStream outputStream, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull(iMicroNode, "Node");
        ValueEnforcer.notNull(outputStream, "OutputStream");
        ValueEnforcer.notNull(iXMLWriterSettings, "Settings");
        try {
            MicroSerializer microSerializer = new MicroSerializer(iXMLWriterSettings);
            microSerializer.write(iMicroNode, outputStream);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        finally {
            StreamUtils.close(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeToWriter(@Nonnull IMicroNode iMicroNode, @Nonnull @WillClose Writer writer, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull(iMicroNode, "Node");
        ValueEnforcer.notNull(writer, "Writer");
        ValueEnforcer.notNull(iXMLWriterSettings, "Settings");
        try {
            MicroSerializer microSerializer = new MicroSerializer(iXMLWriterSettings);
            microSerializer.write(iMicroNode, writer);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        finally {
            StreamUtils.close(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getNodeAsString(@Nonnull IMicroNode iMicroNode, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        NonBlockingStringWriter nonBlockingStringWriter;
        block4: {
            String string;
            ValueEnforcer.notNull(iMicroNode, "Node");
            ValueEnforcer.notNull(iXMLWriterSettings, "Settings");
            nonBlockingStringWriter = null;
            try {
                nonBlockingStringWriter = new NonBlockingStringWriter(51200);
                if (!MicroWriter.writeToWriter(iMicroNode, nonBlockingStringWriter, iXMLWriterSettings).isSuccess()) break block4;
                s_aSizeHdl.addSize(nonBlockingStringWriter.size());
                string = nonBlockingStringWriter.getAsString();
            }
            catch (Throwable throwable) {
                try {
                    s_aLogger.error("Error serializing MicroDOM with settings " + iXMLWriterSettings.toString(), throwable);
                }
                catch (Throwable throwable2) {
                    StreamUtils.close(nonBlockingStringWriter);
                    throw throwable2;
                }
                StreamUtils.close(nonBlockingStringWriter);
            }
            StreamUtils.close(nonBlockingStringWriter);
            return string;
        }
        StreamUtils.close(nonBlockingStringWriter);
        return null;
    }

    @Nullable
    public static String getXMLString(@Nonnull IMicroNode iMicroNode) {
        return MicroWriter.getNodeAsString(iMicroNode, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }
}

