/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.messagedigest;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EMessageDigestAlgorithm {
    MD5("MD5"),
    SHA_1("SHA-1"),
    SHA_256("SHA-256"),
    SHA_384("SHA-384"),
    SHA_512("SHA-512");

    private final String m_sAlgorithm;

    private EMessageDigestAlgorithm(String string2) {
        this.m_sAlgorithm = string2;
    }

    @Nonnull
    @Nonempty
    public String getAlgorithm() {
        return this.m_sAlgorithm;
    }

    @Nullable
    public static EMessageDigestAlgorithm getFromStringIgnoreCase(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            for (EMessageDigestAlgorithm eMessageDigestAlgorithm : EMessageDigestAlgorithm.values()) {
                if (!eMessageDigestAlgorithm.m_sAlgorithm.equalsIgnoreCase(string)) continue;
                return eMessageDigestAlgorithm;
            }
        }
        return null;
    }
}

