/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.io.streams.WrappedOutputStream;
import com.phloc.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugOutputStream
extends WrappedOutputStream {
    private static final Logger s_aLogger = LoggerFactory.getLogger(DebugOutputStream.class);
    private long m_nTotalBytesWritten = 0L;

    public DebugOutputStream(@Nonnull OutputStream outputStream) {
        super(outputStream);
    }

    @Nonnegative
    public final long getBytesWritten() {
        return this.m_nTotalBytesWritten;
    }

    @OverrideOnDemand
    protected void onWrite(@Nonnegative int n, long l) {
        s_aLogger.info("Wrote " + n + " byte(s); now at " + l);
    }

    @Override
    public final void write(int n) throws IOException {
        super.write(n);
        ++this.m_nTotalBytesWritten;
        this.onWrite(1, this.m_nTotalBytesWritten);
    }

    @Override
    public final void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.m_nTotalBytesWritten += (long)n2;
        this.onWrite(n2, this.m_nTotalBytesWritten);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("totalBytesWritten", this.m_nTotalBytesWritten).toString();
    }
}

