/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resourceprovider;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.IReadableResourceProvider;
import com.phloc.commons.io.resource.ClassPathResource;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ClassPathResourceProvider
implements IReadableResourceProvider {
    private final String m_sPrefix;

    public ClassPathResourceProvider() {
        this(null);
    }

    public ClassPathResourceProvider(@Nullable String string) {
        this.m_sPrefix = string;
    }

    @Nullable
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    public boolean supportsReading(@Nullable String string) {
        return StringHelper.hasText(string);
    }

    @Override
    @Nonnull
    public IReadableResource getReadableResource(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Name");
        return new ClassPathResource(this.m_sPrefix == null ? string : this.m_sPrefix + string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ClassPathResourceProvider)) {
            return false;
        }
        ClassPathResourceProvider classPathResourceProvider = (ClassPathResourceProvider)object;
        return EqualsUtils.equals(this.m_sPrefix, classPathResourceProvider.m_sPrefix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPrefix).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("prefix", this.m_sPrefix).toString();
    }
}

