/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.filter;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.file.filter.AbstractFileFilter;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class FileFilterDirectoryPublic
extends AbstractFileFilter {
    private static final FileFilterDirectoryPublic s_aInstance = new FileFilterDirectoryPublic();

    private FileFilterDirectoryPublic() {
    }

    public static FileFilterDirectoryPublic getInstance() {
        return s_aInstance;
    }

    @Override
    public boolean accept(@Nullable File file) {
        return file != null && file.isDirectory() && !FilenameHelper.isHiddenFilename(file);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof FileFilterDirectoryPublic;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).toString();
    }
}

