/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.idfactory;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.idfactory.GlobalIDFactory;
import com.phloc.commons.idfactory.IStringIDFactory;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;

public class StringIDFromGlobalIntIDFactory
implements IStringIDFactory {
    private final String m_sPrefix;

    public StringIDFromGlobalIntIDFactory() {
        this("id");
    }

    public StringIDFromGlobalIntIDFactory(@Nonnull String string) {
        this.m_sPrefix = ValueEnforcer.notNull(string, "Prefix");
    }

    @Nonnull
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    @Nonnull
    public String getNewID() {
        return this.m_sPrefix + Integer.toString(GlobalIDFactory.getNewIntID());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        StringIDFromGlobalIntIDFactory stringIDFromGlobalIntIDFactory = (StringIDFromGlobalIntIDFactory)object;
        return this.m_sPrefix.equals(stringIDFromGlobalIntIDFactory.m_sPrefix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPrefix).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("prefix", this.m_sPrefix).toString();
    }
}

