/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.hash;

import com.phloc.commons.hash.HashCodeImplementationRegistry;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class HashCodeCalculator {
    public static final int MULTIPLIER = 31;
    public static final int HASHCODE_NULL = 129;
    private static final HashCodeCalculator s_aInstance = new HashCodeCalculator();

    private HashCodeCalculator() {
    }

    public static int append(int n, boolean bl) {
        return HashCodeCalculator.append(n, bl ? 1231 : 1237);
    }

    public static int append(int n, byte by) {
        return HashCodeCalculator.append(n, (int)by);
    }

    public static int append(int n, char c) {
        return HashCodeCalculator.append(n, (int)c);
    }

    public static int append(int n, double d) {
        return HashCodeCalculator.append(n, d == 0.0 ? 0L : Double.doubleToLongBits(d));
    }

    public static int append(int n, float f) {
        return HashCodeCalculator.append(n, f == 0.0f ? 0 : Float.floatToIntBits(f));
    }

    public static int append(int n, int n2) {
        return n * 31 + n2;
    }

    public static int append(int n, long l) {
        int n2 = HashCodeCalculator.append(n, (int)(l >>> 32));
        return HashCodeCalculator.append(n2, (int)(l & 0xFFFFFFFFL));
    }

    public static int append(int n, short s) {
        return HashCodeCalculator.append(n, (int)s);
    }

    public static int append(int n, @Nullable Object object) {
        return HashCodeCalculator.append(n, HashCodeImplementationRegistry.getHashCode(object));
    }
}

