/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.equals;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsImplementationRegistry;
import com.phloc.commons.lang.ClassHelper;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ContainerEqualsUtils {
    private ContainerEqualsUtils() {
    }

    @Nullable
    public static EContainerType getContainerTypeOfClass(@Nullable Class<?> clazz) {
        if (clazz != null) {
            if (Set.class.isAssignableFrom(clazz)) {
                return EContainerType.SET;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return EContainerType.COLLECTION;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return EContainerType.MAP;
            }
            if (ClassHelper.isArrayClass(clazz)) {
                return EContainerType.ARRAY;
            }
            if (Iterator.class.isAssignableFrom(clazz)) {
                return EContainerType.ITERATOR;
            }
            if (Iterable.class.isAssignableFrom(clazz)) {
                return EContainerType.ITERABLE;
            }
            if (Enumeration.class.isAssignableFrom(clazz)) {
                return EContainerType.ENUMERATION;
            }
        }
        return null;
    }

    @Nullable
    public static EContainerType getContainerTypeOfObject(@Nullable Object object) {
        return object == null ? null : ContainerEqualsUtils.getContainerTypeOfClass(object.getClass());
    }

    public static boolean isContainerClass(@Nullable Class<?> clazz) {
        return ContainerEqualsUtils.getContainerTypeOfClass(clazz) != null;
    }

    public static boolean isContainerObject(@Nullable Object object) {
        return ContainerEqualsUtils.getContainerTypeOfObject(object) != null;
    }

    private static boolean _areChildrenEqual(@Nullable Object object, @Nullable Object object2) {
        if (ContainerEqualsUtils.isContainerObject(object) && ContainerEqualsUtils.isContainerObject(object2)) {
            return ContainerEqualsUtils.equals(object, object2);
        }
        return EqualsImplementationRegistry.areEqual(object, object2);
    }

    public static boolean equals(@Nullable Object object, @Nullable Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        EContainerType eContainerType = ContainerEqualsUtils.getContainerTypeOfObject(object);
        EContainerType eContainerType2 = ContainerEqualsUtils.getContainerTypeOfObject(object2);
        if (eContainerType == null) {
            throw new IllegalArgumentException("The first parameter is not a container type: " + object);
        }
        if (eContainerType2 == null) {
            throw new IllegalArgumentException("The second parameter is not a container type: " + object2);
        }
        if (!eContainerType.equals((Object)eContainerType2)) {
            return false;
        }
        switch (eContainerType) {
            case COLLECTION: {
                Collection collection = (Collection)object;
                Collection collection2 = (Collection)object2;
                if (collection.isEmpty() && collection2.isEmpty()) {
                    return true;
                }
                if (collection.size() != collection2.size()) {
                    return false;
                }
                Iterator iterator = collection.iterator();
                Iterator iterator2 = collection2.iterator();
                while (iterator.hasNext()) {
                    Object e;
                    Object e2 = iterator.next();
                    if (ContainerEqualsUtils._areChildrenEqual(e2, e = iterator2.next())) continue;
                    return false;
                }
                return true;
            }
            case SET: {
                Set set = (Set)object;
                Set set2 = (Set)object2;
                if (set.isEmpty() && set2.isEmpty()) {
                    return true;
                }
                if (set.size() != set2.size()) {
                    return false;
                }
                for (Object e : set) {
                    if (set2.contains(e)) continue;
                    return false;
                }
                return true;
            }
            case MAP: {
                Map map = (Map)object;
                Map map2 = (Map)object2;
                if (map.isEmpty() && map2.isEmpty()) {
                    return true;
                }
                if (map.size() != map2.size()) {
                    return false;
                }
                for (Map.Entry entry : map.entrySet()) {
                    Object v;
                    Object v2 = entry.getValue();
                    if (ContainerEqualsUtils._areChildrenEqual(v2, v = map2.get(entry.getKey()))) continue;
                    return false;
                }
                return true;
            }
            case ARRAY: {
                Class<?> clazz = object.getClass().getComponentType();
                Class<?> clazz2 = object2.getClass().getComponentType();
                if (ContainerEqualsUtils.isContainerClass(clazz) && ContainerEqualsUtils.isContainerClass(clazz2)) {
                    Object[] objectArray = (Object[])object;
                    Object[] objectArray2 = (Object[])object2;
                    if (objectArray.length != objectArray2.length) {
                        return false;
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object3 = objectArray[i];
                        Object object4 = objectArray2[i];
                        if (ContainerEqualsUtils._areChildrenEqual(object3, object4)) continue;
                        return false;
                    }
                    return true;
                }
                return EqualsImplementationRegistry.areEqual(object, object2);
            }
            case ITERATOR: {
                Iterator iterator = (Iterator)object;
                Iterator iterator3 = (Iterator)object2;
                while (iterator.hasNext()) {
                    Object e;
                    if (!iterator3.hasNext()) {
                        return false;
                    }
                    Object e3 = iterator.next();
                    if (ContainerEqualsUtils._areChildrenEqual(e3, e = iterator3.next())) continue;
                    return false;
                }
                return !iterator3.hasNext();
            }
            case ITERABLE: {
                Iterable iterable = (Iterable)object;
                Iterable iterable2 = (Iterable)object2;
                return ContainerEqualsUtils.equals(iterable.iterator(), iterable2.iterator());
            }
            case ENUMERATION: {
                Enumeration enumeration = (Enumeration)object;
                Enumeration enumeration2 = (Enumeration)object2;
                while (enumeration.hasMoreElements()) {
                    Object e;
                    if (!enumeration2.hasMoreElements()) {
                        return false;
                    }
                    Object e4 = enumeration.nextElement();
                    if (ContainerEqualsUtils._areChildrenEqual(e4, e = enumeration2.nextElement())) continue;
                    return false;
                }
                return !enumeration2.hasMoreElements();
            }
        }
        throw new IllegalStateException("Unhandled container type " + (Object)((Object)eContainerType) + "!");
    }

    @Nonnull
    public static List<?> getAsList(@Nonnull Object object) {
        ValueEnforcer.notNull(object, "Object");
        EContainerType eContainerType = ContainerEqualsUtils.getContainerTypeOfObject(object);
        if (eContainerType == null) {
            return ContainerHelper.newList(object);
        }
        switch (eContainerType) {
            case COLLECTION: {
                if (object instanceof List) {
                    return (List)object;
                }
                return ContainerHelper.newList((Collection)object);
            }
            case SET: {
                return ContainerHelper.newList((Set)object);
            }
            case MAP: {
                return ContainerHelper.newList(((Map)object).entrySet());
            }
            case ARRAY: {
                return ContainerHelper.newList((Object[])object);
            }
            case ITERATOR: {
                return ContainerHelper.newList((Iterator)object);
            }
            case ITERABLE: {
                return ContainerHelper.newList((Iterable)object);
            }
            case ENUMERATION: {
                return ContainerHelper.newList((Enumeration)object);
            }
        }
        throw new IllegalStateException("Unhandled container type " + (Object)((Object)eContainerType) + "!");
    }

    public static boolean equalsAsList(@Nullable Object object, @Nullable Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        List<?> list = ContainerEqualsUtils.getAsList(object);
        List<?> list2 = ContainerEqualsUtils.getAsList(object2);
        return ContainerEqualsUtils.equals(list, list2);
    }

    public static enum EContainerType {
        COLLECTION,
        SET,
        MAP,
        ARRAY,
        ITERATOR,
        ITERABLE,
        ENUMERATION;

    }
}

