/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.charset.CCharset;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.codec.AbstractCodec;
import com.phloc.commons.codec.DecoderException;
import com.phloc.commons.codec.IStringCodec;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.StringHelper;
import java.nio.charset.Charset;
import java.util.BitSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class URLCodec
extends AbstractCodec
implements IStringCodec {
    private static final byte ESCAPE_CHAR = 37;
    private static final byte SPACE = 32;
    private static final byte PLUS = 43;
    private static final BitSet PRINTABLE_CHARS;
    private final Charset m_aCharset;

    public URLCodec() {
        this(CCharset.CHARSET_UTF_8_OBJ);
    }

    public URLCodec(@Nonnull Charset charset) {
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    @Override
    @Nonnull
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static BitSet getDefaultBitSet() {
        return (BitSet)PRINTABLE_CHARS.clone();
    }

    public static final void encodeURL(int n, @Nonnull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream) {
        char c = Character.toUpperCase(StringHelper.getHexChar(n >> 4 & 0xF));
        char c2 = Character.toUpperCase(StringHelper.getHexChar(n & 0xF));
        nonBlockingByteArrayOutputStream.write(37);
        nonBlockingByteArrayOutputStream.write(c);
        nonBlockingByteArrayOutputStream.write(c2);
    }

    @Nonnull
    public static byte[] encodeURL(@Nonnull BitSet bitSet, @Nonnull byte[] byArray) {
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(byArray.length * 2);
        for (byte by : byArray) {
            int n = by & 0xFF;
            if (bitSet.get(n)) {
                if (n == 32) {
                    nonBlockingByteArrayOutputStream.write(43);
                    continue;
                }
                nonBlockingByteArrayOutputStream.write(n);
                continue;
            }
            URLCodec.encodeURL(n, nonBlockingByteArrayOutputStream);
        }
        return nonBlockingByteArrayOutputStream.toByteArray();
    }

    @Override
    @Nullable
    public byte[] encode(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return URLCodec.encodeURL(PRINTABLE_CHARS, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static byte[] decodeURL(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        try {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte by = byArray[i];
                if (by == 43) {
                    nonBlockingByteArrayOutputStream.write(32);
                    continue;
                }
                if (by == 37) {
                    char c;
                    int n2;
                    if (i >= n - 2) {
                        throw new DecoderException("Invalid URL encoding. Premature of string after escape char");
                    }
                    ++i;
                    char c2 = (char)byArray[i];
                    if ((n2 = StringHelper.getHexByte(c2, c = (char)byArray[++i])) < 0) {
                        throw new DecoderException("Invalid URL encoding for " + c2 + c);
                    }
                    nonBlockingByteArrayOutputStream.write(n2);
                    continue;
                }
                nonBlockingByteArrayOutputStream.write(by);
            }
            byte[] byArray2 = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            StreamUtils.close(nonBlockingByteArrayOutputStream);
        }
    }

    @Override
    @Nullable
    public byte[] decode(@Nullable byte[] byArray) {
        return URLCodec.decodeURL(byArray);
    }

    @Override
    @Nullable
    public String encodeText(@Nullable String string) {
        return URLCodec.encodeText(string, this.m_aCharset);
    }

    @Nullable
    public String encodeText(@Nonnull BitSet bitSet, @Nullable String string) {
        return URLCodec.encodeText(bitSet, string, this.m_aCharset);
    }

    @Nullable
    public static String encodeText(@Nullable String string, @Nonnull Charset charset) {
        return URLCodec.encodeText(PRINTABLE_CHARS, string, charset);
    }

    @Nullable
    public static String encodeText(@Nonnull BitSet bitSet, @Nullable String string, @Nonnull Charset charset) {
        if (string == null) {
            return null;
        }
        byte[] byArray = URLCodec.encodeURL(bitSet, CharsetManager.getAsBytes(string, charset));
        return CharsetManager.getAsString(byArray, CCharset.CHARSET_US_ASCII_OBJ);
    }

    @Override
    @Nullable
    public String decodeText(@Nullable String string) {
        return URLCodec.decodeText(string, this.m_aCharset);
    }

    @Nullable
    public static String decodeText(@Nullable String string, @Nonnull Charset charset) {
        if (string == null) {
            return null;
        }
        byte[] byArray = CharsetManager.getAsBytes(string, CCharset.CHARSET_US_ASCII_OBJ);
        byArray = URLCodec.decodeURL(byArray);
        return CharsetManager.getAsString(byArray, charset);
    }

    static {
        int n;
        PRINTABLE_CHARS = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        PRINTABLE_CHARS.set(45);
        PRINTABLE_CHARS.set(95);
        PRINTABLE_CHARS.set(46);
        PRINTABLE_CHARS.set(42);
        PRINTABLE_CHARS.set(32);
    }
}

