/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.changelog;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.changelog.AbstractChangeLogEntry;
import com.phloc.commons.changelog.ChangeLog;
import com.phloc.commons.changelog.EChangeLogAction;
import com.phloc.commons.changelog.EChangeLogCategory;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.text.IMultiLingualText;
import com.phloc.commons.text.IReadonlyMultiLingualText;
import com.phloc.commons.text.impl.MultiLingualText;
import com.phloc.commons.text.impl.ReadonlyMultiLingualText;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ChangeLogEntry
extends AbstractChangeLogEntry {
    private final ChangeLog m_aChangeLog;
    private final EChangeLogAction m_eAction;
    private final EChangeLogCategory m_eCategory;
    private final boolean m_bIsIncompatible;
    private final IMultiLingualText m_aTexts = new MultiLingualText();
    private final List<String> m_aIssues = new ArrayList<String>();

    public ChangeLogEntry(@Nonnull ChangeLog changeLog, @Nonnull Date date, @Nonnull EChangeLogAction eChangeLogAction, @Nonnull EChangeLogCategory eChangeLogCategory, boolean bl) {
        super(date);
        this.m_aChangeLog = ValueEnforcer.notNull(changeLog, "ChangeLog");
        this.m_eAction = ValueEnforcer.notNull(eChangeLogAction, "Action");
        this.m_eCategory = ValueEnforcer.notNull(eChangeLogCategory, "Category");
        this.m_bIsIncompatible = bl;
    }

    @Nonnull
    public ChangeLog getChangeLog() {
        return this.m_aChangeLog;
    }

    @Nonnull
    public EChangeLogAction getAction() {
        return this.m_eAction;
    }

    @Nonnull
    public EChangeLogCategory getCategory() {
        return this.m_eCategory;
    }

    public boolean isIncompatible() {
        return this.m_bIsIncompatible;
    }

    @Nonnull
    EChange setText(@Nonnull IReadonlyMultiLingualText iReadonlyMultiLingualText) {
        ValueEnforcer.notNull(iReadonlyMultiLingualText, "MLT");
        return this.m_aTexts.assignFrom(iReadonlyMultiLingualText);
    }

    @Nonnull
    public EChange setText(@Nonnull Locale locale, @Nullable String string) {
        String string2 = StringHelper.trim(string);
        if (StringHelper.hasNoText(string2)) {
            return EChange.UNCHANGED;
        }
        return this.m_aTexts.setText(locale, string2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public IReadonlyMultiLingualText getAllTexts() {
        return new ReadonlyMultiLingualText(this.m_aTexts);
    }

    @Nullable
    public String getText(Locale locale) {
        return this.m_aTexts.getTextWithLocaleFallback(locale);
    }

    @Nonnull
    public EChange addIssue(@Nullable String string) {
        String string2 = StringHelper.trim(string);
        if (StringHelper.hasNoText(string2)) {
            return EChange.UNCHANGED;
        }
        this.m_aIssues.add(string2);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllIssues() {
        return ContainerHelper.newList(this.m_aIssues);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ChangeLogEntry changeLogEntry = (ChangeLogEntry)object;
        return this.m_aChangeLog.getComponent().equals(changeLogEntry.m_aChangeLog.getComponent()) && this.m_eAction.equals(changeLogEntry.m_eAction) && this.m_eCategory.equals(changeLogEntry.m_eCategory) && this.m_bIsIncompatible == changeLogEntry.m_bIsIncompatible && this.m_aTexts.equals(changeLogEntry.m_aTexts) && this.m_aIssues.equals(changeLogEntry.m_aIssues);
    }

    @Override
    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aChangeLog.getComponent()).append((Enum)this.m_eAction)).append((Enum)this.m_eCategory)).append(this.m_bIsIncompatible).append(this.m_aTexts).append(this.m_aIssues)).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("changelog", this.m_aChangeLog.getComponent()).append("action", this.m_eAction).append("category", this.m_eCategory).append("isIncompatible", this.m_bIsIncompatible).append("texts", this.m_aTexts).append("issues", this.m_aIssues).toString();
    }
}

