/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.cache;

import com.phloc.commons.annotations.IsLocked;
import com.phloc.commons.cache.AbstractCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractNotifyingCache<KEYTYPE, VALUETYPE>
extends AbstractCache<KEYTYPE, VALUETYPE> {
    public AbstractNotifyingCache(@Nonnull String string) {
        super(string);
    }

    @Nonnull
    @IsLocked(value=IsLocked.ELockType.WRITE)
    protected abstract VALUETYPE getValueToCache(KEYTYPE var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public final VALUETYPE getFromCache(KEYTYPE KEYTYPE) {
        Object VALUETYPE = super.getFromCacheNoStats(KEYTYPE);
        if (VALUETYPE == null) {
            this.m_aRWLock.writeLock().lock();
            try {
                VALUETYPE = super.getFromCacheNoStatsNotLocked(KEYTYPE);
                if (VALUETYPE == null) {
                    VALUETYPE = this.getValueToCache(KEYTYPE);
                    if (VALUETYPE == null) {
                        throw new IllegalStateException("The value to cache was null for key '" + KEYTYPE + "'");
                    }
                    super.putInCacheNotLocked(KEYTYPE, VALUETYPE);
                    this.m_aCacheAccessStats.cacheMiss();
                }
                this.m_aCacheAccessStats.cacheHit();
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        } else {
            this.m_aCacheAccessStats.cacheHit();
        }
        return VALUETYPE;
    }
}

