/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.cache;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.MustBeLocked;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.cache.ISimpleCache;
import com.phloc.commons.cache.SimpleCache;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.jmx.JMXUtils;
import com.phloc.commons.state.EChange;
import com.phloc.commons.stats.IStatisticsHandlerCache;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractCache<KEYTYPE, VALUETYPE>
implements ISimpleCache<KEYTYPE, VALUETYPE> {
    public static final boolean DEFAULT_JMX_ENABLED = false;
    public static final String STATISTICS_PREFIX = "cache:";
    private static final AtomicBoolean s_aJMXEnabled = new AtomicBoolean(false);
    protected final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final String m_sCacheName;
    protected final IStatisticsHandlerCache m_aCacheAccessStats;
    private final IStatisticsHandlerCounter m_aCacheRemoveStats;
    private final IStatisticsHandlerCounter m_aCacheClearStats;
    private volatile Map<KEYTYPE, VALUETYPE> m_aCache;

    public AbstractCache(@Nonnull @Nonempty String string) {
        this.m_sCacheName = ValueEnforcer.notEmpty(string, "cacheName");
        this.m_aCacheAccessStats = StatisticsManager.getCacheHandler(STATISTICS_PREFIX + string + "$access");
        this.m_aCacheRemoveStats = StatisticsManager.getCounterHandler(STATISTICS_PREFIX + string + "$remove");
        this.m_aCacheClearStats = StatisticsManager.getCounterHandler(STATISTICS_PREFIX + string + "$clear");
        if (AbstractCache.isJMXEnabled()) {
            JMXUtils.exposeMBeanWithAutoName(new SimpleCache(this), string);
        }
    }

    public static boolean isJMXEnabled() {
        return s_aJMXEnabled.get();
    }

    public static void setJMXEnabled(boolean bl) {
        s_aJMXEnabled.set(bl);
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sCacheName;
    }

    @Nonnull
    @OverrideOnDemand
    protected Map<KEYTYPE, VALUETYPE> createCache() {
        return new WeakHashMap();
    }

    @MustBeLocked(value=MustBeLocked.ELockType.WRITE)
    protected final void putInCacheNotLocked(@Nonnull KEYTYPE KEYTYPE, @Nonnull VALUETYPE VALUETYPE) {
        ValueEnforcer.notNull(KEYTYPE, "cacheKey");
        ValueEnforcer.notNull(VALUETYPE, "cacheValue");
        if (this.m_aCache == null) {
            this.m_aCache = this.createCache();
            if (this.m_aCache == null) {
                throw new IllegalStateException("No cache created!");
            }
        }
        this.m_aCache.put(KEYTYPE, VALUETYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void putInCache(@Nonnull KEYTYPE KEYTYPE, @Nonnull VALUETYPE VALUETYPE) {
        ValueEnforcer.notNull(KEYTYPE, "cacheKey");
        ValueEnforcer.notNull(VALUETYPE, "cacheValue");
        this.m_aRWLock.writeLock().lock();
        try {
            this.putInCacheNotLocked(KEYTYPE, VALUETYPE);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @MustBeLocked(value=MustBeLocked.ELockType.READ)
    protected final VALUETYPE getFromCacheNoStatsNotLocked(@Nullable KEYTYPE KEYTYPE) {
        return this.m_aCache == null ? null : (VALUETYPE)this.m_aCache.get(KEYTYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @OverridingMethodsMustInvokeSuper
    protected final VALUETYPE getFromCacheNoStats(@Nullable KEYTYPE KEYTYPE) {
        this.m_aRWLock.readLock().lock();
        try {
            VALUETYPE VALUETYPE = this.getFromCacheNoStatsNotLocked(KEYTYPE);
            return VALUETYPE;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    private void _updateStats(boolean bl) {
        if (bl) {
            this.m_aCacheAccessStats.cacheMiss();
        } else {
            this.m_aCacheAccessStats.cacheHit();
        }
    }

    @Nullable
    protected final VALUETYPE getFromCacheNotLocked(@Nullable KEYTYPE KEYTYPE) {
        VALUETYPE VALUETYPE = this.getFromCacheNoStatsNotLocked(KEYTYPE);
        this._updateStats(VALUETYPE == null);
        return VALUETYPE;
    }

    @Override
    @Nullable
    @OverridingMethodsMustInvokeSuper
    public VALUETYPE getFromCache(KEYTYPE KEYTYPE) {
        VALUETYPE VALUETYPE = this.getFromCacheNoStats(KEYTYPE);
        this._updateStats(VALUETYPE == null);
        return VALUETYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public EChange removeFromCache(KEYTYPE KEYTYPE) {
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aCache == null || this.m_aCache.remove(KEYTYPE) == null) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        this.m_aCacheRemoveStats.increment();
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public EChange clearCache() {
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aCache == null || this.m_aCache.isEmpty()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.m_aCache.clear();
            this.m_aCacheClearStats.increment();
            EChange eChange = EChange.CHANGED;
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnegative
    public int size() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = ContainerHelper.getSize(this.m_aCache);
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = ContainerHelper.isEmpty(this.m_aCache);
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotEmpty() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = ContainerHelper.isNotEmpty(this.m_aCache);
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("cacheName", this.m_sCacheName).append("content", this.m_aCache).toString();
    }
}

