/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons;

import com.phloc.commons.annotations.DevelopersNote;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.priviledged.AccessControllerHelper;
import com.phloc.commons.priviledged.PrivilegedActionSystemClearProperty;
import com.phloc.commons.priviledged.PrivilegedActionSystemGetProperties;
import com.phloc.commons.priviledged.PrivilegedActionSystemGetProperty;
import com.phloc.commons.priviledged.PrivilegedActionSystemSetProperty;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class SystemProperties {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SystemProperties.class);
    private static final Set<String> s_aWarnedPropertyNames = new HashSet<String>();
    private static final SystemProperties s_aInstance = new SystemProperties();

    private SystemProperties() {
    }

    @Nullable
    public static String getPropertyValueOrNull(@Nullable String string) {
        return string == null ? null : AccessControllerHelper.call(new PrivilegedActionSystemGetProperty(string));
    }

    @Nullable
    public static String getPropertyValue(@Nullable String string) {
        String string2 = null;
        if (string != null && (string2 = SystemProperties.getPropertyValueOrNull(string)) == null && s_aWarnedPropertyNames.add(string) && !string.contains("phloc")) {
            s_aLogger.warn("System property '" + string + "' is not set!");
        }
        return string2;
    }

    public static void setPropertyValue(@Nonnull String string, @Nullable String string2) {
        if (string2 == null) {
            SystemProperties.removePropertyValue(string);
        } else {
            AccessControllerHelper.run(new PrivilegedActionSystemSetProperty(string, string2));
        }
    }

    @Nullable
    public static String removePropertyValue(@Nonnull String string) {
        return AccessControllerHelper.call(new PrivilegedActionSystemClearProperty(string));
    }

    @Nullable
    public static String getJavaVersion() {
        return SystemProperties.getPropertyValue("java.version");
    }

    @Nullable
    public static String getJavaVendor() {
        return SystemProperties.getPropertyValue("java.vendor");
    }

    @Nullable
    public static String getJavaVendorURL() {
        return SystemProperties.getPropertyValue("java.vendor.url");
    }

    @Nullable
    public static String getJavaHome() {
        return SystemProperties.getPropertyValue("java.home");
    }

    @Nullable
    public static String getJavaClassVersion() {
        return SystemProperties.getPropertyValue("java.class.version");
    }

    @Nullable
    public static String getJavaClassPath() {
        return SystemProperties.getPropertyValue("java.class.path");
    }

    @Nullable
    public static String getJavaLibraryPath() {
        return SystemProperties.getPropertyValue("java.library.path");
    }

    @Nullable
    public static String getOsName() {
        return SystemProperties.getPropertyValue("os.name");
    }

    @Nullable
    public static String getOsArch() {
        return SystemProperties.getPropertyValue("os.arch");
    }

    @Nullable
    public static String getOsVersion() {
        return SystemProperties.getPropertyValue("os.version");
    }

    @Nullable
    public static String getFileSeparator() {
        return SystemProperties.getPropertyValue("file.separator");
    }

    @Nullable
    public static String getPathSeparator() {
        return SystemProperties.getPropertyValue("path.separator");
    }

    @Nullable
    public static String getLineSeparator() {
        return SystemProperties.getPropertyValue("line.separator");
    }

    @Nullable
    public static String getUserName() {
        return SystemProperties.getPropertyValue("user.name");
    }

    @Nullable
    public static String getUserHome() {
        return SystemProperties.getPropertyValue("user.home");
    }

    @Nullable
    public static String getUserDir() {
        return SystemProperties.getPropertyValue("user.dir");
    }

    @Nullable
    public static String getJavaVmSpecificationVersion() {
        return SystemProperties.getPropertyValue("java.vm.specification.version");
    }

    @Nullable
    public static String getJavaVmSpecificationVendor() {
        return SystemProperties.getPropertyValue("java.vm.specification.vendor");
    }

    @Nullable
    public static String getJavaVmSpecificationUrl() {
        return SystemProperties.getPropertyValue("java.vm.specification.url");
    }

    @Nullable
    public static String getJavaVmVersion() {
        return SystemProperties.getPropertyValue("java.vm.version");
    }

    @Nullable
    public static String getJavaVmVendor() {
        return SystemProperties.getPropertyValue("java.vm.vendor");
    }

    @Nullable
    public static String getJavaVmUrl() {
        return SystemProperties.getPropertyValue("java.vm.url");
    }

    @Nullable
    public static String getJavaSpecificationVersion() {
        return SystemProperties.getPropertyValue("java.specification.version");
    }

    @Nullable
    public static String getJavaSpecificationVendor() {
        return SystemProperties.getPropertyValue("java.specification.vendor");
    }

    @Nullable
    public static String getJavaSpecificationUrl() {
        return SystemProperties.getPropertyValue("java.specification.url");
    }

    @Nullable
    @DevelopersNote(value="This property is not part of the language but part of the Sun SDK")
    public static String getTmpDir() {
        return SystemProperties.getPropertyValue("java.io.tmpdir");
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllPropertyNames() {
        return new HashSet<String>(SystemProperties.getAllProperties().keySet());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Map<String, String> getAllProperties() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Properties properties = AccessControllerHelper.call(new PrivilegedActionSystemGetProperties());
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string = (String)entry.getKey();
                hashMap.put(string, (String)entry.getValue());
            }
        }
        return hashMap;
    }

    public static boolean containsPropertyName(String string) {
        return SystemProperties.getAllProperties().containsKey(string);
    }

    public static void setXMLEntityExpansionLimit(int n) {
        SystemProperties.setPropertyValue("entityExpansionLimit", Integer.toString(n));
        SystemProperties.setPropertyValue("jdx.xml.entityExpansionLimit", Integer.toString(n));
    }

    public static int getXMLEntityExpansionLimit() {
        String string = SystemProperties.getPropertyValueOrNull("jdx.xml.entityExpansionLimit");
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull("entityExpansionLimit");
        }
        if (string == null) {
            return 64000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLElementAttributeLimit(int n) {
        SystemProperties.setPropertyValue("elementAttributeLimit", Integer.toString(n));
        SystemProperties.setPropertyValue("jdx.xml.elementAttributeLimit", Integer.toString(n));
    }

    public static int getXMLElementAttributeLimit() {
        String string = SystemProperties.getPropertyValueOrNull("jdx.xml.elementAttributeLimit");
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull("elementAttributeLimit");
        }
        if (string == null) {
            return 10000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxOccur(int n) {
        SystemProperties.setPropertyValue("maxOccur", Integer.toString(n));
        SystemProperties.setPropertyValue("jdx.xml.maxOccur", Integer.toString(n));
    }

    public static int getXMLMaxOccur() {
        String string = SystemProperties.getPropertyValueOrNull("jdx.xml.maxOccur");
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull("maxOccur");
        }
        if (string == null) {
            return 5000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLTotalEntitySizeLimit(int n) {
        SystemProperties.setPropertyValue("jdx.xml.totalEntitySizeLimit", Integer.toString(n));
    }

    public static int getXMLTotalEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull("jdx.xml.totalEntitySizeLimit");
        if (string == null) {
            return 500000000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxGeneralEntitySizeLimit(int n) {
        SystemProperties.setPropertyValue("jdx.xml.maxGeneralEntitySizeLimit", Integer.toString(n));
    }

    public static int getXMLMaxGeneralEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull("jdx.xml.maxGeneralEntitySizeLimit");
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxParameterEntitySizeLimit(int n) {
        SystemProperties.setPropertyValue("jdx.xml.maxParameterEntitySizeLimit", Integer.toString(n));
    }

    public static int getXMLMaxParameterEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull("jdx.xml.maxParameterEntitySizeLimit");
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }
}

