/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.consumer;

import com.eclipsesource.jaxrs.consumer.internal.ClientHelper;
import com.eclipsesource.jaxrs.consumer.internal.ResourceInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import javax.ws.rs.Path;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class ConsumerFactory {
    public static <T> T createConsumer(String baseUrl, Class<T> type) {
        return ConsumerFactory.createConsumer(baseUrl, (Configuration)new ClientConfig(), type);
    }

    public static <T> T createConsumer(String baseUrl, Configuration configuration, Class<T> type) {
        ConsumerFactory.checkUrl(baseUrl);
        ConsumerFactory.checkType(type);
        ConsumerFactory.checkConfiguration(configuration);
        ConsumerFactory.checkAnnotation(type);
        ConsumerFactory.ensureTypeIsAnInterface(type);
        Path path = type.getAnnotation(Path.class);
        ConsumerFactory.ensureMultiPartFeature(configuration, type);
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)ConsumerFactory.createHandler(baseUrl, configuration, path));
    }

    public static <T> T createConsumer(String baseUrl, Client client, Class<T> type) {
        ConsumerFactory.checkUrl(baseUrl);
        ConsumerFactory.checkType(type);
        ConsumerFactory.checkClient(client);
        ConsumerFactory.checkAnnotation(type);
        ConsumerFactory.ensureTypeIsAnInterface(type);
        Path path = type.getAnnotation(Path.class);
        ConsumerFactory.ensureMultiPartFeature(client.getConfiguration(), type);
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)ConsumerFactory.createHandler(baseUrl, client, path));
    }

    private static <T> void ensureMultiPartFeature(Configuration configuration, Class<T> type) {
        if (ConsumerFactory.hasFormDataParam(type)) {
            ((ClientConfig)configuration).register(MultiPartFeature.class);
        }
    }

    private static boolean hasFormDataParam(Class<?> type) {
        Method[] methodArray = type.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (ClientHelper.hasFormAnnotation(method, FormDataParam.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static ResourceInvocationHandler createHandler(String baseUrl, Configuration configuration, Path path) {
        return new ResourceInvocationHandler(String.valueOf(baseUrl) + path.value(), configuration);
    }

    private static ResourceInvocationHandler createHandler(String baseUrl, Client client, Path path) {
        return new ResourceInvocationHandler(String.valueOf(baseUrl) + path.value(), client);
    }

    private static void checkUrl(String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException invalidUrlException) {
            throw new IllegalArgumentException(String.valueOf(url) + " is not a valid url", invalidUrlException);
        }
    }

    private static void checkType(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null.");
        }
    }

    private static void checkConfiguration(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration must not be null");
        }
    }

    private static void checkClient(Client client) {
        if (client == null) {
            throw new IllegalArgumentException("Client must not be null");
        }
    }

    private static void checkAnnotation(Class<?> type) {
        if (!type.isAnnotationPresent(Path.class)) {
            throw new IllegalArgumentException(String.valueOf(type.getName()) + " is not a Resource. No @Path Annotation.");
        }
    }

    private static void ensureTypeIsAnInterface(Class<?> type) {
        if (!type.isInterface()) {
            throw new IllegalArgumentException(String.valueOf(type.getName()) + " is not an interface. You do not " + "want a dependency to cglib, do you?");
        }
    }

    private ConsumerFactory() {
    }
}

