/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.crypt.Base64Coder;
import ch.rgw.tools.ExHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class SoapConverter {
    public static final Namespace ns = Namespace.getNamespace((String)"soap", (String)"http://www.w3.org/2001/12/soap-envelope");
    public static final String TYPE_STRING = "string";
    public static final String TYPE_INTEGRAL = "integral";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_ARRAY = "array";
    public static final String TYPE_MAP = "map";
    public static final String TYPE_SERIALIZED = "serializedPOJO";
    public static final String TYPE_SIGNATURE = "signature";
    private Document doc;
    private Element eRoot;
    private Element eBody;
    private boolean bValid;

    public boolean load(byte[] input) {
        SAXBuilder builder = new SAXBuilder();
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        try {
            this.doc = builder.build((InputStream)bais);
            this.eRoot = this.doc.getRootElement();
            this.bValid = true;
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            this.bValid = false;
        }
        return this.bValid;
    }

    public Document getXML() {
        return this.doc;
    }

    public boolean load(String input) {
        SAXBuilder builder = new SAXBuilder();
        try {
            CharArrayReader car = new CharArrayReader(input.toCharArray());
            this.doc = builder.build((Reader)car);
            this.eRoot = this.doc.getRootElement();
            this.bValid = true;
        }
        catch (Exception e) {
            ExHandler.handle(e);
            this.bValid = false;
        }
        return this.bValid;
    }

    public Element getParameter(String name) {
        if (this.bValid) {
            Element body = this.eRoot.getChild("Body", ns);
            List params = body.getChildren("parameter", ns);
            for (Element el : params) {
                if (!el.getAttributeValue("name").equalsIgnoreCase(name)) continue;
                return el;
            }
        }
        return null;
    }

    public Map<String, Serializable> loadHash(Element parm) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        List params = parm.getChildren("parameter", ns);
        for (Element param : params) {
            String type = param.getAttributeValue("type");
            String s = param.getText();
            Object res = null;
            try {
                if (type.equals(TYPE_STRING)) {
                    res = s;
                } else if (type.equals(TYPE_INTEGRAL)) {
                    res = Long.parseLong(s);
                } else if (type.equals(TYPE_FLOAT)) {
                    res = Double.parseDouble(s);
                } else if (type.equals(TYPE_ARRAY)) {
                    res = Base64Coder.decode(s);
                } else if (type.equals(TYPE_MAP)) {
                    res = (Serializable)((Object)this.loadHash(param));
                } else if (type.equals(TYPE_SERIALIZED)) {
                    byte[] barr = Base64Coder.decode(s);
                    ByteArrayInputStream bais = new ByteArrayInputStream(barr);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    res = (Serializable)ois.readObject();
                    bais.close();
                    ois.close();
                } else {
                    res = "** unsupported type ** " + type;
                }
            }
            catch (Exception ex) {
                ExHandler.handle(ex);
                res = "** parse error **";
            }
            ret.put(param.getAttributeValue("name"), (Serializable)res);
        }
        return ret;
    }

    public Map<String, Serializable> getParameters() {
        if (this.bValid) {
            Element body = this.eRoot.getChild("Body", ns);
            return this.loadHash(body);
        }
        return null;
    }

    public void create(String creator, String version, String provider) {
        this.eRoot = new Element("Envelope", ns);
        Element eHeader = new Element("Header", ns);
        Element eID = new Element("Creator", ns);
        eID.setAttribute("name", creator);
        eID.setAttribute("version", version);
        eID.setAttribute("provider", provider);
        eHeader.addContent((Content)eID);
        this.eRoot.addContent((Content)eHeader);
        this.eBody = new Element("Body", ns);
        this.eRoot.addContent((Content)this.eBody);
        this.doc = new Document(this.eRoot);
        this.bValid = true;
    }

    public String toString() {
        if (this.doc != null && this.eRoot != null) {
            Format format = Format.getPrettyFormat();
            format.setEncoding("utf-8");
            XMLOutputter xmlo = new XMLOutputter(format);
            return xmlo.outputString(this.doc);
        }
        return null;
    }

    private Element createParameter(Element parent, String name, String type) {
        if (parent == null) {
            parent = this.eBody;
        }
        Element ret = new Element("parameter", ns);
        ret.setAttribute("type", type);
        ret.setAttribute("name", name);
        parent.addContent((Content)ret);
        return ret;
    }

    public void addString(String name, String s) {
        this.createParameter(this.eBody, name, TYPE_STRING).setText(s);
    }

    public void addIntegral(String name, long x) {
        this.createParameter(this.eBody, name, TYPE_INTEGRAL).setText(Long.toString(x));
    }

    public void addFloat(String name, double x) {
        this.createParameter(this.eBody, name, TYPE_FLOAT).setText(Double.toString(x));
    }

    public void addArray(String name, byte[] arr) {
        String res = new String(Base64Coder.encode(arr));
        this.createParameter(this.eBody, name, TYPE_ARRAY).setText(res);
    }

    public void addObject(Element parent, String name, Serializable obj) throws Exception {
        if (obj != null) {
            if (obj instanceof String) {
                this.createParameter(parent, name, TYPE_STRING).setText((String)((Object)obj));
            } else if (obj instanceof Double || obj instanceof Float) {
                this.createParameter(parent, name, TYPE_FLOAT).setText(Double.toString((Double)obj));
            } else if (obj instanceof Integer || obj instanceof Long || obj instanceof Byte) {
                this.createParameter(parent, name, TYPE_INTEGRAL).setText(obj.toString());
            } else if (obj instanceof byte[]) {
                String res = new String(Base64Coder.encode((byte[])obj));
                this.createParameter(parent, name, TYPE_ARRAY).setText(res);
            } else if (obj instanceof HashMap) {
                this.addMap(parent, name, (Map)((Object)obj));
            } else if (obj instanceof Serializable) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream os = new ObjectOutputStream(baos);
                os.writeObject(obj);
                os.close();
                baos.close();
                byte[] barr = baos.toByteArray();
                this.createParameter(parent, name, TYPE_SERIALIZED).setText(new String(Base64Coder.encode(barr)));
            } else {
                throw new Exception("Invalid type for SoapConverter: " + obj.getClass().getName());
            }
        }
    }

    public void addMap(Element parent, String name, Map<String, Serializable> map) throws Exception {
        Element ret = this.createParameter(parent, name, TYPE_MAP);
        Set<Map.Entry<String, Serializable>> entries = map.entrySet();
        for (Map.Entry<String, Serializable> entry : entries) {
            this.addObject(ret, entry.getKey(), entry.getValue());
        }
    }
}

