/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class Result<T> {
    static final Logger log = Logger.getLogger("Result");
    List<msg> list = new ArrayList<msg>();
    private SEVERITY severity = SEVERITY.OK;
    private int code;

    public SEVERITY getSeverity() {
        return this.severity;
    }

    public int getCode() {
        return this.code;
    }

    public List<msg> getMessages() {
        return this.list;
    }

    public boolean isOK() {
        if (this.list.size() > 0) {
            for (msg m : this.list) {
                if (m.severity == SEVERITY.OK) continue;
                return false;
            }
        }
        return true;
    }

    public T get() {
        if (this.list.size() == 0) {
            return null;
        }
        msg result = this.list.get(0);
        if (this.list.size() > 1) {
            for (msg m : this.list) {
                if (m.severity.ordinal() <= this.list.get((int)0).severity.ordinal()) continue;
                result = m;
            }
        }
        return result.result;
    }

    public Result(T result) {
        this.add(SEVERITY.OK, 0, "Ok", result, false);
    }

    public Result<T> add(SEVERITY severity, int code, String text, T result, boolean log) {
        this.list.add(new msg(code, text, severity, result));
        if (severity.ordinal() > this.severity.ordinal()) {
            this.severity = severity;
            this.code = code;
        }
        return this;
    }

    public Result<T> add(Result<T> r) {
        this.list.addAll(r.list);
        return this;
    }

    public Result() {
    }

    public Result(SEVERITY sev, List<msg> msgs) {
        this.list.addAll(msgs);
    }

    public Result(SEVERITY severity, int code, String text, T result, boolean bLog) {
        this.add(severity, code, text, result, bLog);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        for (msg m : this.list) {
            sb.append(m.text).append("\n");
        }
        return sb.toString();
    }

    public static enum SEVERITY {
        OK,
        WARNING,
        ERROR,
        FATAL;

    }

    public class msg {
        int code;
        String text;
        SEVERITY severity;
        T result;

        msg(int c, String t, SEVERITY s, T r) {
            this.code = c;
            this.text = t;
            this.severity = s;
            this.result = r;
        }

        public SEVERITY getSeverity() {
            return this.severity;
        }

        public int getCode() {
            return this.code;
        }

        public String getText() {
            return this.text;
        }
    }
}

