/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class PasswordValidator {
    private static final PasswordRule[] RULES = new PasswordRule[]{new BaseRule(PasswordValidationResult.TOO_SHORT){

        @Override
        public boolean passRule(String password) {
            return password.length() >= 8;
        }
    }, new BaseRule(PasswordValidationResult.MISSING_UPPERCASE){
        private final Pattern ucletter = Pattern.compile(".*[\\p{Lu}].*");

        @Override
        public boolean passRule(String password) {
            return this.ucletter.matcher(password).matches();
        }
    }, new BaseRule(PasswordValidationResult.MISSING_LOWERCASE){
        private final Pattern ucletter = Pattern.compile(".*[\\p{Ll}].*");

        @Override
        public boolean passRule(String password) {
            return this.ucletter.matcher(password).matches();
        }
    }, new BaseRule(PasswordValidationResult.MISSING_NUMBER){
        private final Pattern ucletter = Pattern.compile(".*[0-9].*");

        @Override
        public boolean passRule(String password) {
            return this.ucletter.matcher(password).matches();
        }
    }};

    public static Set<PasswordValidationResult> validateNewPass(String pass1, String pass2, Set<String> exclusionSet) {
        if (pass1 == null || pass2 == null) {
            return Collections.singleton(PasswordValidationResult.IS_EMPTY);
        }
        if (pass1.isEmpty() || pass2.isEmpty()) {
            return Collections.singleton(PasswordValidationResult.IS_EMPTY);
        }
        if (!pass1.equals(pass2)) {
            return Collections.singleton(PasswordValidationResult.DO_NOT_MATCH);
        }
        for (String value : exclusionSet) {
            if (!pass1.equalsIgnoreCase(value)) continue;
            return Collections.singleton(PasswordValidationResult.EXCLUDED_PASSWORD);
        }
        HashSet<PasswordValidationResult> result = new HashSet<PasswordValidationResult>();
        boolean pass = true;
        PasswordRule[] passwordRuleArray = RULES;
        int n = RULES.length;
        int n2 = 0;
        while (n2 < n) {
            PasswordRule rule = passwordRuleArray[n2];
            if (!rule.passRule(pass1)) {
                result.add(rule.failResult());
                pass = false;
            }
            ++n2;
        }
        return pass ? Collections.singleton(PasswordValidationResult.SUCCESS) : result;
    }

    public static Set<PasswordValidationResult> validateNewPass(String pass1, String pass2) {
        return PasswordValidator.validateNewPass(pass1, pass2, Collections.emptySet());
    }

    private static abstract class BaseRule
    implements PasswordRule {
        private final PasswordValidationResult failResult;

        BaseRule(PasswordValidationResult failResult) {
            this.failResult = failResult;
        }

        @Override
        public PasswordValidationResult failResult() {
            return this.failResult;
        }
    }

    private static interface PasswordRule {
        public boolean passRule(String var1);

        public PasswordValidationResult failResult();
    }

    public static enum PasswordValidationResult {
        SUCCESS,
        IS_EMPTY,
        DO_NOT_MATCH,
        TOO_SHORT,
        MISSING_UPPERCASE,
        MISSING_LOWERCASE,
        MISSING_NUMBER,
        EXCLUDED_PASSWORD;

    }
}

