/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.io;

import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class LockFile {
    File baseDir;
    String baseName;
    int maxNum;
    int timeOutSeconds;

    public LockFile(File dir, String basename, int maxNum, int timeoutSeconds) {
        this.baseDir = dir;
        this.baseName = basename;
        this.maxNum = maxNum;
        this.timeOutSeconds = timeoutSeconds;
    }

    public int lock() throws IOException {
        int n = 1;
        while (n <= this.maxNum) {
            File file = new File(this.baseDir, this.constructFilename(n));
            if (!this.isLockValid(file) && this.createLockfile(file)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    private boolean isLockValid(File file) throws IOException {
        if (!file.exists()) {
            return false;
        }
        if (!file.canWrite()) {
            throw new IOException("Can't write " + file.getAbsolutePath());
        }
        TimeTool now = new TimeTool();
        DataInputStream dais = new DataInputStream(new FileInputStream(file));
        String ts = dais.readUTF();
        TimeTool tt = new TimeTool();
        dais.close();
        if (tt.set(ts)) {
            if (tt.secondsTo(now) > this.timeOutSeconds) {
                if (file.delete()) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (file.delete()) {
            return false;
        }
        throw new IOException("Can not delete " + file.getAbsolutePath());
    }

    private boolean createLockfile(File file) throws IOException {
        if (!file.createNewFile()) {
            return false;
        }
        file.deleteOnExit();
        DataOutputStream daos = new DataOutputStream(new FileOutputStream(file));
        daos.writeUTF(new TimeTool().toString(5));
        daos.close();
        return true;
    }

    private String constructFilename(int n) {
        return this.baseName + "." + Integer.toString(n);
    }

    public boolean updateLock(int n) {
        File file = new File(this.baseDir, this.constructFilename(n));
        if (!file.exists()) {
            return false;
        }
        try {
            DataOutputStream daos = new DataOutputStream(new FileOutputStream(file));
            daos.writeUTF(new TimeTool().toString(5));
            daos.close();
            return true;
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return false;
        }
    }

    public boolean existsLock() throws IOException {
        int n = 1;
        while (n <= this.maxNum) {
            File file = new File(this.baseDir, this.constructFilename(n));
            if (!this.isLockValid(file)) continue;
            return true;
        }
        return false;
    }
}

