/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.crypt;

import ch.rgw.crypt.Cryptologist;
import ch.rgw.crypt.CryptologistException;
import ch.rgw.crypt.JCEKeyManager;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JCECrypter
implements Cryptologist {
    private static final String KEY_ALGO = "AES";
    private static final String SIGNATURE_ALGO = "SHA512withRSA";
    private static final String SYMM_CIPHER_ALGO = "Blowfish";
    private static final String RSA_ALGO = "RSA/ECB/PKCS1Padding";
    public static short VERSION = (short)258;
    public static short MAGIC = (short)-4130;
    public static short KEY_MARKER = (short)16;
    public static short IV_MARKER = (short)32;
    public static short DATA_MARKER = (short)48;
    protected JCEKeyManager km;
    protected String userKey;
    protected char[] pwd;

    public JCECrypter(String keystore, char[] kspwd, String mykey, char[] keypwd) throws Exception {
        this(kspwd, mykey, keypwd);
        if (keystore == null) {
            keystore = String.valueOf(System.getProperty("user.home")) + File.separator + ".JCECrypter";
            if (kspwd == null) {
                kspwd = "JCECrypterDefault".toCharArray();
            }
        }
        this.km = new JCEKeyManager(keystore, null, kspwd);
        if (this.km.load(true)) {
            if (!this.km.existsPrivate(mykey)) {
                KeyPair kp = this.km.generateKeys();
                X509Certificate cert = this.km.generateCertificate(kp.getPublic(), kp.getPrivate(), this.userKey, this.userKey, null, null);
                this.km.addKeyPair(kp.getPrivate(), cert, this.pwd);
                this.km.save();
            }
        } else {
            this.km = null;
        }
    }

    protected JCECrypter(char[] kspwd, String mykey, char[] keypwd) {
        this.userKey = mykey;
        this.pwd = keypwd;
    }

    protected void finalize() throws Throwable {
        if (this.pwd != null) {
            int i = 0;
            while (i < this.pwd.length) {
                this.pwd[i] = '\u0000';
                ++i;
            }
        }
        super.finalize();
    }

    @Override
    public Result<byte[]> decrypt(byte[] encrypted) {
        try {
            PrivateKey pk = this.km.getPrivateKey(this.userKey, this.pwd);
            Cipher rsaCip = Cipher.getInstance(RSA_ALGO);
            rsaCip.init(2, pk);
            ByteArrayInputStream bais = new ByteArrayInputStream(encrypted);
            DataInputStream di = new DataInputStream(bais);
            short magic = di.readShort();
            if (magic != MAGIC) {
                return new Result<Object>(Result.SEVERITY.ERROR, 1, "Bad data format while trying to decrypt", null, true);
            }
            short version = di.readShort();
            short mark = di.readShort();
            if (mark != KEY_MARKER) {
                return new Result<Object>(Result.SEVERITY.ERROR, 2, "unexpected block marker", null, true);
            }
            int len = di.readInt();
            byte[] d = new byte[len];
            di.readFully(d);
            SecretKeySpec bfKey = new SecretKeySpec(rsaCip.doFinal(d), SYMM_CIPHER_ALGO);
            Cipher aesCip = Cipher.getInstance(SYMM_CIPHER_ALGO);
            aesCip.init(2, bfKey);
            mark = di.readShort();
            if (mark != DATA_MARKER) {
                return new Result<Object>(Result.SEVERITY.ERROR, 4, "unexpected block marker", null, true);
            }
            len = di.readInt();
            d = new byte[len];
            di.readFully(d);
            return new Result<byte[]>(aesCip.doFinal(d));
        }
        catch (Exception e) {
            ExHandler.handle(e);
            return null;
        }
    }

    @Override
    public void decrypt(InputStream source, OutputStream dest) throws CryptologistException {
        try {
            PrivateKey pk = this.km.getPrivateKey(this.userKey, this.pwd);
            Cipher rsaCip = Cipher.getInstance(RSA_ALGO);
            rsaCip.init(2, pk);
            DataInputStream di = new DataInputStream(source);
            short magic = di.readShort();
            if (magic != MAGIC) {
                throw new CryptologistException("Bad data format while trying to decrypt", 4);
            }
            short version = di.readShort();
            short mark = di.readShort();
            if (mark != KEY_MARKER) {
                throw new CryptologistException("unexpected block marker", 4);
            }
            int len = di.readInt();
            byte[] d = new byte[len];
            di.readFully(d);
            SecretKeySpec bfKey = new SecretKeySpec(rsaCip.doFinal(d), SYMM_CIPHER_ALGO);
            Cipher aesCip = Cipher.getInstance(SYMM_CIPHER_ALGO);
            aesCip.init(2, bfKey);
            while (di.available() > 1) {
                mark = di.readShort();
                if (mark != DATA_MARKER) {
                    throw new CryptologistException("unexpected block marker", 4);
                }
                len = di.readInt();
                d = new byte[len];
                di.readFully(d);
                byte[] dec = aesCip.doFinal(d);
                dest.write(dec);
            }
            dest.flush();
        }
        catch (Exception e) {
            throw new CryptologistException("Error while decoding " + e.getMessage(), 3);
        }
    }

    @Override
    public void encrypt(InputStream source, OutputStream dest, String receiverKeyName) throws CryptologistException {
        int BUFLEN = 65535;
        try {
            int in;
            PublicKey cert = this.km.getPublicKey(receiverKeyName);
            Cipher bfCip = Cipher.getInstance(SYMM_CIPHER_ALGO);
            byte[] bfKey = this.generateBlowfishKey();
            SecretKeySpec spec = new SecretKeySpec(bfKey, SYMM_CIPHER_ALGO);
            bfCip.init(1, spec);
            Cipher rsaCip = Cipher.getInstance(RSA_ALGO);
            rsaCip.init(1, cert);
            DataOutputStream dao = new DataOutputStream(dest);
            dao.writeShort(MAGIC);
            dao.writeShort(VERSION);
            this.writeBlock(dao, rsaCip.doFinal(bfKey), KEY_MARKER);
            byte[] buffer = new byte[65535];
            while ((in = source.read(buffer)) == 65535) {
                this.writeBlock(dao, bfCip.doFinal(buffer), DATA_MARKER);
            }
            if (in > 0) {
                this.writeBlock(dao, bfCip.doFinal(buffer, 0, in), DATA_MARKER);
            }
            dao.flush();
        }
        catch (Exception e) {
            throw new CryptologistException("Encryption failed: " + e.getMessage(), 9);
        }
    }

    @Override
    public byte[] encrypt(byte[] source, String receiverKeyName) {
        try {
            PublicKey cert = this.km.getPublicKey(receiverKeyName);
            Cipher bfCip = Cipher.getInstance(SYMM_CIPHER_ALGO);
            byte[] bfKey = this.generateBlowfishKey();
            SecretKeySpec spec = new SecretKeySpec(bfKey, SYMM_CIPHER_ALGO);
            bfCip.init(1, spec);
            Cipher rsaCip = Cipher.getInstance(RSA_ALGO);
            rsaCip.init(1, cert);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dao = new DataOutputStream(baos);
            dao.writeShort(MAGIC);
            dao.writeShort(VERSION);
            this.writeBlock(dao, rsaCip.doFinal(bfKey), KEY_MARKER);
            this.writeBlock(dao, bfCip.doFinal(source), DATA_MARKER);
            dao.flush();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    private void writeBlock(DataOutputStream o, byte[] block, int marker) throws Exception {
        o.writeShort(marker);
        o.writeInt(block.length);
        o.write(block);
        int i = 0;
        while (i < block.length) {
            block[i] = 0;
            ++i;
        }
    }

    @Override
    public byte[] sign(byte[] source) {
        try {
            Signature sig = Signature.getInstance(SIGNATURE_ALGO);
            PrivateKey pk = this.km.getPrivateKey(this.userKey, this.pwd);
            SecureRandom sr = new SecureRandom();
            sig.initSign(pk, sr);
            sig.update(source);
            return sig.sign();
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    @Override
    public Cryptologist.VERIFY_RESULT verify(byte[] data, byte[] signature, String signerKeyName) {
        try {
            Signature sig = Signature.getInstance(SIGNATURE_ALGO);
            PublicKey pk = this.km.getPublicKey(signerKeyName);
            if (pk == null) {
                return Cryptologist.VERIFY_RESULT.SIGNER_UNKNOWN;
            }
            sig.initVerify(pk);
            sig.update(data);
            if (sig.verify(signature)) {
                return Cryptologist.VERIFY_RESULT.OK;
            }
            return Cryptologist.VERIFY_RESULT.BAD_SIGNATURE;
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return Cryptologist.VERIFY_RESULT.INTERNAL_ERROR;
        }
    }

    @Override
    public boolean hasCertificateOf(String alias) {
        return this.km.existsCertificate(alias);
    }

    @Override
    public boolean hasKeyOf(String alias) {
        return this.km.existsPrivate(alias);
    }

    @Override
    public boolean addCertificate(X509Certificate cert) {
        if (this.km.addCertificate(cert)) {
            return this.km.save();
        }
        return false;
    }

    @Override
    public boolean addCertificate(byte[] certEncoded) {
        ByteArrayInputStream bais = new ByteArrayInputStream(certEncoded);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
            return this.addCertificate(cert);
        }
        catch (CertificateException e) {
            ExHandler.handle(e);
            return false;
        }
    }

    @Override
    public KeyPair generateKeys(String alias, char[] keypwd, TimeTool validFrom, TimeTool validUntil) {
        KeyPair ret = this.km.generateKeys();
        if (alias != null) {
            X509Certificate cert = this.generateCertificate(ret.getPublic(), alias, validFrom, validUntil);
            try {
                this.km.addKeyPair(ret.getPrivate(), cert, keypwd);
                this.km.save();
            }
            catch (Exception ex) {
                ExHandler.handle(ex);
                return null;
            }
        }
        return ret;
    }

    @Override
    public X509Certificate generateCertificate(PublicKey pk, String alias, TimeTool validFrom, TimeTool validUntil) {
        PrivateKey priv = this.km.getPrivateKey(this.userKey, this.pwd);
        try {
            X509Certificate ret = this.km.generateCertificate(pk, priv, this.userKey, alias, validFrom, validUntil);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getUser() {
        return this.userKey;
    }

    private byte[] generateBlowfishKey() {
        try {
            KeyGenerator key_gen = KeyGenerator.getInstance(SYMM_CIPHER_ALGO);
            SecretKey key = key_gen.generateKey();
            return key.getEncoded();
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    private Key generateAESKey() {
        try {
            KeyGenerator key_gen = KeyGenerator.getInstance(KEY_ALGO);
            key_gen.init(128, this.km.getRandom());
            SecretKey aes_key = key_gen.generateKey();
            return aes_key;
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        return this.km.getCertificate(alias);
    }

    @Override
    public byte[] getCertificateEncoded(String alias) throws CryptologistException {
        X509Certificate cert = this.getCertificate(alias);
        if (cert != null) {
            try {
                return cert.getEncoded();
            }
            catch (CertificateEncodingException ce) {
                throw new CryptologistException("Could not encode certificate", 8);
            }
        }
        return null;
    }

    @Override
    public boolean isFunctional() {
        return true;
    }

    @Override
    public boolean removeCertificate(String alias) {
        return this.km.removeKey(alias);
    }
}

