/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.compress;

import ch.rgw.compress.Huff;
import ch.rgw.compress.HuffmanOutputStream;
import ch.rgw.compress.HuffmanTree;
import ch.rgw.io.BitInputStream;
import ch.rgw.tools.IntTool;
import java.io.IOException;
import java.io.InputStream;

public class HuffmanInputStream
extends InputStream {
    InputStream in;
    BitInputStream bis;
    HuffmanTree tree = new HuffmanTree();
    int dyn;
    int[] tbl;
    int counter;

    public static String Version() {
        return "0.5.4";
    }

    public HuffmanInputStream(InputStream in) throws IOException {
        this.in = in;
        byte[] sig = new byte[HuffmanOutputStream.signature.length];
        in.read(sig);
        int i = 0;
        while (i < sig.length) {
            if (sig[i] != HuffmanOutputStream.signature[i]) {
                throw new IOException("Bad Stream Header");
            }
            ++i;
        }
        this.dyn = IntTool.readInt(in);
        this.tree.build(HuffmanTree.loadTable(in));
        this.bis = new BitInputStream(in);
        if (this.dyn != 0) {
            this.tbl = new int[256];
            this.counter = 0;
        }
    }

    @Override
    public int read() throws IOException {
        int ret = Huff.readByte(this.tree.getRootNode(), this.bis);
        if (ret != -1 && this.dyn > 0) {
            int n = ret;
            this.tbl[n] = this.tbl[n] + 1;
            if (++this.counter == this.dyn) {
                this.tree.build(this.tbl);
                this.tbl = new int[256];
                this.counter = 0;
            }
        }
        return ret;
    }

    @Override
    public int available() throws IOException {
        return this.bis.available();
    }
}

