/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.types;

import org.apache.commons.lang3.StringUtils;

public class PathologicDescription {
    private Description description;
    private String reference;

    public static PathologicDescription of(String string) {
        PathologicDescription ret = new PathologicDescription();
        String[] parts = string.split("\\|\\|");
        if (parts.length == 2 && !parts[0].isEmpty()) {
            ret.description = Description.valueOf(parts[0]);
            ret.reference = parts[1];
        } else if (parts.length == 1 && !parts[0].isEmpty()) {
            ret.description = Description.valueOf(parts[0]);
            ret.reference = "";
        }
        return ret;
    }

    public PathologicDescription(Description description) {
        this(description, "");
    }

    public PathologicDescription(Description description, String reference) {
        this.description = description;
        this.reference = reference != null ? StringUtils.abbreviate((String)reference, (int)90) : "";
    }

    private PathologicDescription() {
        this.description = Description.UNKNOWN;
        this.reference = "";
    }

    public String toString() {
        return String.valueOf(this.description.name()) + "||" + this.reference;
    }

    public Description getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public Object getLabel() {
        if (this.reference != null && !this.reference.isEmpty()) {
            return this.getDescription().getLabel() + " (" + this.reference + ")";
        }
        return this.getDescription().getLabel();
    }

    public static enum Description {
        PATHO_IMPORT("Aus Import"),
        PATHO_IMPORT_NO_INFO("Aus Import (Keine Information vorhanden)"),
        PATHO_ABSOLUT("Absoluter Wert"),
        PATHO_REF("Resultat Referenzwert"),
        PATHO_REF_ITEM("Parameter Referenzwert"),
        PATHO_NOREF("Kein Referenzwert"),
        PATHO_MANUAL("Manuell"),
        UNKNOWN("?");

        private String label;

        private Description(String label) {
            this.label = label;
        }

        public Object getLabel() {
            return this.label;
        }
    }
}

