/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContactGender implements Enumerator
{
    MALE(0, "MALE", "MALE"),
    FEMALE(1, "FEMALE", "FEMALE"),
    UNDEFINED(2, "UNDEFINED", "UNDEFINED"),
    UNKNOWN(3, "UNKNOWN", "UNKNOWN");

    public static final int MALE_VALUE = 0;
    public static final int FEMALE_VALUE = 1;
    public static final int UNDEFINED_VALUE = 2;
    public static final int UNKNOWN_VALUE = 3;
    private static final ContactGender[] VALUES_ARRAY;
    public static final List<ContactGender> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContactGender[]{MALE, FEMALE, UNDEFINED, UNKNOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContactGender get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContactGender result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContactGender getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContactGender result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContactGender get(int value) {
        switch (value) {
            case 0: {
                return MALE;
            }
            case 1: {
                return FEMALE;
            }
            case 2: {
                return UNDEFINED;
            }
            case 3: {
                return UNKNOWN;
            }
        }
        return null;
    }

    private ContactGender(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

