/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.text.model;

import ch.rgw.tools.TimeTool;
import java.io.CharArrayReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Verifier;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Samdas {
    public static final String ELEM_ROOT = "EMR";
    public static final String ELEM_TEXT = "text";
    public static final String ELEM_RECORD = "record";
    public static final Namespace ns = Namespace.getNamespace((String)"samdas", (String)"http://www.elexis.ch/XSD");
    public static final Namespace nsxsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XML Schema-instance");
    public static final Namespace nsschema = Namespace.getNamespace((String)"schemaLocation", (String)"http://www.elexis.ch/XSD EMR.xsd");
    private Document doc;
    private Element eRoot;

    public Samdas(String input) {
        SAXBuilder builder = new SAXBuilder();
        try {
            CharArrayReader car = new CharArrayReader(input.trim().toCharArray());
            this.doc = builder.build((Reader)car);
            this.eRoot = this.doc.getRootElement();
        }
        catch (Exception e) {
            this.doc = new Document();
            this.eRoot = new Element(ELEM_ROOT, ns);
            this.doc.setRootElement(this.eRoot);
            Element record = new Element(ELEM_RECORD, ns);
            Element text = new Element(ELEM_TEXT, ns);
            this.doc.getRootElement().addContent((Content)record);
            record.addContent((Content)text);
            text.setText(input);
        }
    }

    public Samdas() {
        this.doc = new Document();
        this.eRoot = new Element(ELEM_ROOT, ns);
        this.doc.setRootElement(this.eRoot);
    }

    public void setRoot(Element el) {
        this.doc.removeContent();
        this.eRoot = el;
        this.doc.setRootElement(el);
    }

    public Document getDocument() {
        return this.doc;
    }

    public String toString() {
        XMLOutputter xo = new XMLOutputter(Format.getRawFormat());
        return xo.outputString(this.doc);
    }

    public String getRecordText() {
        Element rec = this.getRecordElement();
        String ret = rec.getChildText(ELEM_TEXT, ns);
        return ret == null ? "" : ret;
    }

    public Element getRecordElement() {
        Element ret = this.eRoot.getChild(ELEM_RECORD, ns);
        if (ret == null) {
            ret = new Element(ELEM_RECORD, ns);
            this.eRoot.addContent((Content)ret);
        }
        return ret;
    }

    public Record getRecord() {
        return new Record(this.getRecordElement());
    }

    public void add(Record r) {
        this.eRoot.addContent((Content)r.eRecord);
    }

    @Deprecated
    public static class Analyse
    extends Finding {
        public Analyse() {
            super(new Element("analysis"));
        }
    }

    public static class Box {
    }

    @Deprecated
    public static class ECG
    extends Finding {
        public ECG() {
            super(new Element("ecg"));
        }
    }

    @Deprecated
    public static class Finding {
        protected Element el;

        Finding(Element e) {
            this.el = e;
        }

        Finding(String typ, String date, String labEAN, boolean abnormal) {
            this.el = new Element(typ);
            this.el.setAttribute("date", date);
            this.el.setAttribute("labEAN", labEAN);
            this.el.setAttribute("abnormal", Boolean.toString(abnormal).toLowerCase());
        }

        public TimeTool getDate() {
            return new TimeTool(this.el.getAttributeValue("date"));
        }

        public boolean isAbnormal() {
            return this.el.getAttributeValue("abormal").equals("true");
        }
    }

    @Deprecated
    public static class Image
    extends Finding {
        public Image() {
            super(new Element("image"));
        }
    }

    public static class Markup
    extends Range {
        public static final String ATTR_TYPE = "type";

        Markup(Element e) {
            super(e);
        }

        public Markup(int pos, int length, String typ) {
            super("markup", pos, length);
            this.el.setAttribute(ATTR_TYPE, typ);
        }

        public String getType() {
            return this.el.getAttributeValue(ATTR_TYPE);
        }
    }

    public static class Range {
        public static final String ATTR_LENGTH = "length";
        public static final String ATTR_FROM = "from";
        protected Element el;

        Range(Element e) {
            this.el = e;
        }

        Range(String typ, int pos, int length) {
            this.el = new Element(typ, ns);
            this.el.setAttribute(ATTR_FROM, Integer.toString(pos));
            this.el.setAttribute(ATTR_LENGTH, Integer.toString(length));
        }

        public int getPos() {
            return Integer.parseInt(this.el.getAttributeValue(ATTR_FROM));
        }

        public void setPos(int p) {
            this.el.setAttribute(ATTR_FROM, Integer.toString(p));
        }

        public int getLength() {
            return Integer.parseInt(this.el.getAttributeValue(ATTR_LENGTH));
        }

        public void setLength(int length) {
            this.el.setAttribute(ATTR_LENGTH, Integer.toString(length));
        }
    }

    public static class Record {
        private static final String ELEM_SECTION = "section";
        public static final String ELEM_MARKUP = "markup";
        public static final String ELEM_XREF = "xref";
        public static final String ATTR_DATE = "date";
        public static final String ATTR_RESPONSIBLE_EAN = "responsibleEAN";
        public static final String ATTR_AUTHOR = "author";
        private Element eRecord;

        public Record(Element e) {
            this.eRecord = e;
        }

        public String getAuthor() {
            return this.eRecord.getAttributeValue(ATTR_AUTHOR);
        }

        public String getResponsibleEAN() {
            return this.eRecord.getAttributeValue(ATTR_RESPONSIBLE_EAN);
        }

        public TimeTool getDate() {
            return new TimeTool(this.eRecord.getAttributeValue(ATTR_DATE));
        }

        public Element getTextElement() {
            Element ret = this.eRecord.getChild(Samdas.ELEM_TEXT, ns);
            if (ret == null) {
                ret = new Element(Samdas.ELEM_TEXT, ns);
                this.eRecord.addContent((Content)ret);
            }
            return ret;
        }

        public void setText(String t) {
            Element eText = this.getTextElement();
            eText.setText(this.getValidXMLString(t));
        }

        public String getText() {
            Element eText = this.getTextElement();
            return eText.getText();
        }

        public List<XRef> getXrefs() {
            List lElm = this.eRecord.getChildren(ELEM_XREF, ns);
            ArrayList<XRef> ret = new ArrayList<XRef>(lElm.size());
            for (Element el : lElm) {
                ret.add(new XRef(el));
            }
            return ret;
        }

        public List<Markup> getMarkups() {
            List lElm = this.eRecord.getChildren(ELEM_MARKUP, ns);
            ArrayList<Markup> ret = new ArrayList<Markup>(lElm.size());
            for (Element el : lElm) {
                ret.add(new Markup(el));
            }
            return ret;
        }

        public List<Section> getSections() {
            List lElm = this.eRecord.getChildren(ELEM_SECTION, ns);
            ArrayList<Section> ret = new ArrayList<Section>(lElm.size());
            for (Element el : lElm) {
                ret.add(new Section(el));
            }
            return ret;
        }

        public void add(Range x) {
            this.eRecord.addContent((Content)x.el);
        }

        public void remove(Range x) {
            this.eRecord.removeContent((Content)x.el);
        }

        private String getValidXMLString(String source) {
            StringBuilder ret = new StringBuilder();
            int i = 0;
            int len = source.length();
            while (i < len) {
                if (Verifier.isXMLCharacter((int)source.charAt(i))) {
                    ret.append(source.charAt(i));
                }
                ++i;
            }
            return ret.toString();
        }
    }

    public static class Section
    extends Range {
        private static final String ATTR_NAME = "name";

        Section(Element e) {
            super(e);
        }

        public Section(int pos, int length, String name) {
            super("section", pos, length);
            this.el.setAttribute(ATTR_NAME, name);
        }
    }

    public static class Style {
        private double opacity;
        private long rgbBackground;
    }

    public static class XRef
    extends Range {
        public static final String ATTR_ID = "id";
        public static final String ATTR_PROVIDER = "provider";

        XRef(Element e) {
            super(e);
        }

        public XRef(String provider, String id, int pos, int length) {
            super("xref", pos, length);
            this.el.setAttribute(ATTR_PROVIDER, provider);
            this.el.setAttribute(ATTR_ID, id);
        }

        public String getProvider() {
            return this.el.getAttributeValue(ATTR_PROVIDER);
        }

        public String getID() {
            return this.el.getAttributeValue(ATTR_ID);
        }
    }
}

