/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.status;

import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.status.ObjectStatus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;

public class StatusUtil {
    public static void printStatus(Logger log, IStatus status) {
        StatusUtil.print(log, "", status);
    }

    public static void print(Logger log, String indent, IStatus status) {
        if (status.isMultiStatus()) {
            log.warn(String.valueOf(indent) + status.getMessage().replace('\n', ' '));
            String childIndent = String.valueOf(indent) + "  ";
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus c = iStatusArray[n2];
                StatusUtil.print(log, childIndent, c);
                ++n2;
            }
        } else {
            log.warn(String.valueOf(indent) + status.getMessage().replace('\n', ' '));
        }
    }

    public static void printStatus(PrintStream out, IStatus status) {
        StatusUtil.print(out, "", status);
    }

    public static String printStatus(IStatus status) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                PrintStream ps = new PrintStream(baos);
                StatusUtil.printStatus(ps, status);
                return baos.toString(Charset.defaultCharset().toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    private static void print(PrintStream printStream, String indent, IStatus status) {
        if (status.isMultiStatus()) {
            printStream.print(String.valueOf(indent) + status.getMessage());
            String childIndent = String.valueOf(indent) + "  ";
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus c = iStatusArray[n2];
                StatusUtil.print(printStream, childIndent, c);
                ++n2;
            }
        } else if (status instanceof ObjectStatus) {
            ObjectStatus os = (ObjectStatus)status;
            printStream.println(os != null ? os.getObject().toString() : null);
        } else {
            printStream.println(String.valueOf(indent) + status.getMessage());
        }
    }

    public static IStatus errorSeeLog(String pluginId) {
        return new Status(4, pluginId, "Execution error, see log.");
    }

    public static void logStatus(@NonNull Logger log, @NonNull IStatus status, boolean includeExceptionIfAvailable) {
        if (status.isOK()) {
            return;
        }
        String message = status.isMultiStatus() ? "[MULTISTATUS] " + status.getMessage() : status.getMessage();
        boolean includeException = includeExceptionIfAvailable && status.getException() != null;
        int severity = status.getSeverity();
        switch (severity) {
            case 4: {
                if (includeException) {
                    log.error(message, status.getException());
                    break;
                }
                log.error(message);
                break;
            }
            case 2: {
                if (includeException) {
                    log.warn(message, status.getException());
                    break;
                }
                log.warn(message);
                break;
            }
            case 1: 
            case 8: {
                if (includeException) {
                    log.info(message, status.getException());
                    break;
                }
                log.info(message);
                break;
            }
        }
        if (status.isMultiStatus()) {
            Arrays.asList(status.getChildren()).stream().forEach(c -> StatusUtil.logStatus(log, c, true));
        }
    }

    public static void logStatus(Logger log, IStatus status) {
        StatusUtil.logStatus(log, status, true);
    }
}

