/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.article.IArticle;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public interface IStockService {
    public IStockEntry storeArticleInStock(IStock var1, String var2);

    public void unstoreArticleFromStock(IStock var1, String var2);

    public Integer getCumulatedStockForArticle(IArticle var1);

    public Availability getCumulatedAvailabilityForArticle(IArticle var1);

    public Availability getArticleAvailabilityForStock(IStock var1, String var2);

    public List<? extends IStockEntry> findAllStockEntriesForStock(IStock var1);

    public List<? extends IStockEntry> findAllStockEntriesForArticle(String var1);

    public IStockEntry findPreferredStockEntryForArticle(String var1, String var2);

    public IStockEntry findStockEntryForArticleInStock(IStock var1, String var2);

    public IStatus performSingleDisposal(IArticle var1, int var2, String var3);

    public IStatus performSingleReturn(IArticle var1, int var2, String var3);

    public static Availability determineAvailability(int current, int min, boolean triggerOnIsBelow) {
        if (current <= 0) {
            return Availability.OUT_OF_STOCK;
        }
        if (triggerOnIsBelow && current >= min || !triggerOnIsBelow && current > min) {
            return Availability.IN_STOCK;
        }
        return Availability.CRITICAL_STOCK;
    }

    public static Availability determineAvailability(int current, int min) {
        return IStockService.determineAvailability(current, min, false);
    }

    public static enum Availability {
        IN_STOCK,
        CRITICAL_STOCK,
        OUT_OF_STOCK;

    }
}

