/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.issue;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.interfaces.INumericEnum;
import java.util.ResourceBundle;

public enum ProcessStatus implements INumericEnum,
ILocalizedEnum
{
    OPEN(0),
    DUE(1),
    OVERDUE(2),
    CLOSED(3),
    ON_HOLD(4),
    IN_PROGRESS(5);

    private final int numeric;

    private ProcessStatus(int numeric) {
        this.numeric = numeric;
    }

    @Override
    public int numericValue() {
        return this.numeric;
    }

    @Override
    public String getLocaleText() {
        try {
            return ResourceBundle.getBundle("ch.elexis.core.l10n.messages").getString(String.valueOf(ProcessStatus.class.getSimpleName()) + "_" + this.name());
        }
        catch (Exception e) {
            return this.name();
        }
    }

    public static ProcessStatus byNumericSafe(String statusIn) {
        ProcessStatus[] processStatusArray = ProcessStatus.values();
        int n = processStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessStatus status = processStatusArray[n2];
            if (Integer.toString(status.numericValue()).equalsIgnoreCase(statusIn)) {
                return status;
            }
            ++n2;
        }
        return OPEN;
    }
}

