/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.interfaces.ILocalizedEnum;
import ch.elexis.core.interfaces.INumericEnum;
import java.util.ResourceBundle;

public enum MaritalStatus implements INumericEnum,
ILocalizedEnum
{
    UNKNOWN(0),
    ANNULLED(1),
    DIVORCED(2),
    INTERLOCUTORY(3),
    LEGALLY_SEPARATED(4),
    MARRIED(5),
    POLYGAMOUS(6),
    NEVER_MARRIED(7),
    DOMESTIC_PARTNER(8),
    UNMARRIED(9),
    WIDOWED(10);

    private final int numeric;

    private MaritalStatus(int numeric) {
        this.numeric = numeric;
    }

    @Override
    public int numericValue() {
        return this.numeric;
    }

    @Override
    public String getLocaleText() {
        try {
            return ResourceBundle.getBundle("ch.elexis.core.l10n.messages").getString(String.valueOf(MaritalStatus.class.getSimpleName()) + "_" + this.name());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return this.name();
        }
    }

    public static MaritalStatus byNumericSafe(String priority) {
        MaritalStatus[] maritalStatusArray = MaritalStatus.values();
        int n = maritalStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            MaritalStatus prio = maritalStatusArray[n2];
            if (Integer.toString(prio.numericValue()).equalsIgnoreCase(priority)) {
                return prio;
            }
            ++n2;
        }
        return UNKNOWN;
    }
}

