/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.lock.types;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class LockInfo {
    @XmlTransient
    public static final long EVICTION_TIMEOUT = 30000L;
    @XmlTransient
    private long refreshMillis;
    @XmlElement
    private String elementId;
    @XmlElement
    private String elementType;
    @XmlElement
    private String user;
    @XmlElement
    private Date creationDate;
    @XmlElement
    private String systemUuid;

    public LockInfo() {
    }

    public LockInfo(String storeToString, String userId, String systemUuid) {
        String[] split = storeToString.split("::");
        if (split.length != 2) {
            throw new IllegalArgumentException(storeToString);
        }
        this.elementId = split[1];
        this.elementType = split[0];
        this.user = userId;
        this.creationDate = new Date();
        this.systemUuid = systemUuid;
    }

    public String getElementType() {
        return this.elementType;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getUser() {
        return this.user;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getSystemUuid() {
        return this.systemUuid;
    }

    public static String getElementId(String storeToString) {
        String[] split = storeToString.split("::");
        if (split.length == 2) {
            return split[1];
        }
        throw new IllegalArgumentException(storeToString);
    }

    public String getElementStoreToString() {
        return String.valueOf(this.elementType) + "::" + this.elementId;
    }

    public void refresh() {
        this.refreshMillis = System.currentTimeMillis();
    }

    public boolean evict(long currentMillis) {
        if (this.refreshMillis == 0L) {
            this.refreshMillis = currentMillis;
        } else if (currentMillis - this.refreshMillis > 30000L) {
            return true;
        }
        return false;
    }

    public String toString() {
        return "LockInfo [elementType=" + this.elementType + ", elementId=" + this.elementId + ", user=" + this.user + ", systemUuid=" + this.systemUuid + ", creationDate=" + this.creationDate + ", refreshMillis=" + this.refreshMillis + "]";
    }
}

