/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.scripting;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileWriter;
import java.util.List;

public class TarmedTaxpunktkorrektur {
    FileWriter writer;

    public String recalc(String dateFrom, String abrsystem, double newTP) {
        block20: {
            TimeTool ttFrom;
            block21: {
                File file = new File(String.valueOf(System.getProperty("user.home")) + File.separator + "elexis" + File.separator + "taxpunktkorrektur.log");
                this.writer = new FileWriter(file);
                if (!SWTHelper.askYesNo("WARNUNG", "Wirklich alle Konsultationen seit dem " + dateFrom + " auf " + Double.toString(newTP) + " umrechnen?")) break block20;
                ttFrom = new TimeTool();
                if (ttFrom.set(dateFrom)) break block21;
                this.writer.write("bad date format: " + dateFrom + " aborting.\n");
                try {
                    this.writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return "Datumformat kann nicht interpretiert werden. Bitte als dd.mm.yyyy eingeben";
            }
            StringBuilder del = new StringBuilder();
            del.append("DELETE FROM VK_PREISE WHERE TYP=").append(JdbcLink.wrap((String)abrsystem)).append(" and DATUM_VON>=").append(JdbcLink.wrap((String)ttFrom.toString(9)));
            this.writer.write("removing old tp values\n");
            PersistentObject.getConnection().exec(del.toString());
            del = new StringBuilder();
            TimeTool yesterday = new TimeTool(ttFrom);
            yesterday.addDays(-1);
            del.append("UPDATE VK_PREISE SET DATUM_BIS=").append(JdbcLink.wrap((String)yesterday.toString(9))).append(" WHERE DATUM_BIS>").append(JdbcLink.wrap((String)yesterday.toString(9)));
            this.writer.write("adjusting multiplicators\n");
            PersistentObject.getConnection().exec(del.toString());
            del = new StringBuilder();
            del.append("INSERT INTO VK_PREISE (ID,DATUM_VON,DATUM_BIS,TYP,MULTIPLIKATOR) VALUES (").append(JdbcLink.wrap((String)StringTool.unique((String)"rtsu"))).append(",").append(JdbcLink.wrap((String)ttFrom.toString(9))).append(",").append("'99991231',").append(JdbcLink.wrap((String)abrsystem)).append(",").append(JdbcLink.wrap((String)Double.toString(newTP))).append(");");
            this.writer.write("inserting new TP value\n");
            PersistentObject.getConnection().exec(del.toString());
            this.writer.write("collecting consultations\n");
            Query qbe = new Query(Konsultation.class);
            qbe.add("RechnungsID", "is", null);
            qbe.add("Datum", ">=", ttFrom.toString(9));
            int i = 0;
            Money old = new Money();
            Money changed = new Money();
            for (Konsultation k : qbe.execute()) {
                Fall fall = k.getFall();
                String abr = fall.getAbrechnungsSystem();
                if (abr.equals(abrsystem)) {
                    List vv = k.getLeistungen();
                    for (Verrechnet v : vv) {
                        old.addMoney(new Money(v.get("VK_Preis")).multiply((double)v.getZahl() / 100.0));
                        v.setStandardPreis();
                        changed.addMoney(v.getBruttoPreis().multiply((double)v.getZahl()));
                    }
                    this.writer.write("konvertierte " + k.getVerboseLabel() + "\n");
                }
                ++i;
            }
            String string = "Abgeschlossen. " + Integer.toString(i) + " Konsultationen wurden umgrechnet.\nAlter Gesamtbetrag: " + old.getAmountAsString() + "\nNeuer Gesamtbetrag: " + changed.getAmountAsString();
            try {
                this.writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }
        try {
            try {
                this.writer.write("aborted by user\n");
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                String string = ex.getMessage();
                try {
                    this.writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return string;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception exception) {}
        }
        return "allgemeiner Fehler";
    }
}

