/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.textsystem.provider;

import ch.elexis.core.ui.views.textsystem.model.TextTemplate;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class TextTemplateFilter
extends ViewerFilter {
    private String searchTerm;

    public void setSearchTerm(String term) {
        this.searchTerm = ".*" + term.toLowerCase() + ".*";
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchTerm == null || this.searchTerm.length() == 0) {
            return true;
        }
        TextTemplate tt = (TextTemplate)element;
        String name = tt.getName().toLowerCase();
        if (name.matches(this.searchTerm)) {
            return true;
        }
        String desc = tt.getDescription().toLowerCase();
        if (desc.matches(this.searchTerm)) {
            return true;
        }
        String mime = tt.getMimeTypePrintname().toLowerCase();
        if (mime.matches(this.searchTerm)) {
            return true;
        }
        String mandant = tt.getMandantLabel().toLowerCase();
        return mandant.matches(this.searchTerm);
    }
}

