/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.reminder;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.ui.locks.LockRequestingAction;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.data.Reminder;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;

public class ReminderStatusSubMenu
extends MenuManager {
    private CommonViewer cv;

    public ReminderStatusSubMenu(CommonViewer cv) {
        super("Status...");
        this.cv = cv;
        this.setRemoveAllWhenShown(true);
        this.addMenuListener(new ReminderStatusSubMenuListener());
    }

    private class ReminderStatusSubMenuListener
    implements IMenuListener {
        private ReminderStatusSubMenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            Object[] selection = ReminderStatusSubMenu.this.cv.getSelection();
            if (selection != null && selection.length == 1) {
                if (selection[0] instanceof Reminder) {
                    Reminder reminder = (Reminder)selection[0];
                    manager.add((IAction)new StatusAction(ProcessStatus.OPEN, reminder));
                    manager.add((IAction)new StatusAction(ProcessStatus.IN_PROGRESS, reminder));
                    manager.add((IAction)new StatusAction(ProcessStatus.CLOSED, reminder));
                    manager.add((IAction)new StatusAction(ProcessStatus.ON_HOLD, reminder));
                }
            } else {
                manager.add((IAction)new Action("Multiple selection"){

                    public boolean isEnabled() {
                        return false;
                    }
                });
            }
        }

        private class StatusAction
        extends LockRequestingAction<Reminder> {
            private final ProcessStatus representedStatus;
            private Reminder reminder;

            public StatusAction(ProcessStatus representedStatus, Reminder reminder) {
                super(representedStatus.getLocaleText(), 16);
                this.representedStatus = representedStatus;
                this.reminder = reminder;
                ProcessStatus status = reminder.getProcessStatus();
                if (ProcessStatus.DUE == status || ProcessStatus.OVERDUE == status) {
                    this.setChecked(representedStatus == ProcessStatus.OPEN);
                } else {
                    this.setChecked(representedStatus == status);
                }
            }

            public boolean isChecked() {
                ProcessStatus status = this.reminder.getProcessStatus();
                if (ProcessStatus.DUE == status || ProcessStatus.OVERDUE == status) {
                    return this.representedStatus == ProcessStatus.OPEN;
                }
                return this.representedStatus == this.reminder.getProcessStatus();
            }

            public String getText() {
                String text = super.getText();
                ProcessStatus status = this.reminder.getProcessStatus();
                if ((ProcessStatus.DUE == status || ProcessStatus.OVERDUE == status) && ProcessStatus.OPEN == this.representedStatus) {
                    return String.valueOf(text) + " (" + status.getLocaleText() + ")";
                }
                return text;
            }

            @Override
            public Reminder getTargetedObject() {
                return this.reminder;
            }

            @Override
            public void doRun(Reminder element) {
                element.setProcessStatus(this.representedStatus);
                ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)element, Reminder.class, 4)});
            }
        }
    }
}

