/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.DateInput;
import ch.elexis.core.ui.util.MoneyInput;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RnFilterDialog
extends TitleAreaDialog {
    static final String FROM = Messages.RnFilterDialog_fromDate;
    static final String UNTIL = Messages.RnFilterDialog_untilDate;
    String[] ret;
    MoneyInput miVon;
    MoneyInput miBis;
    DateInput diRnVon;
    DateInput diRnBis;
    DateInput diStatVon;
    DateInput diStatBis;
    DateInput diOutVon;
    DateInput diOutBis;
    private TimeTool invoiceDateFrom;
    private TimeTool invoiceDateTo;
    private TimeTool invoiceStateDateFrom;
    private TimeTool invoiceStateDateTo;
    private TimeTool invoiceOutputDateFrom;
    private TimeTool invoiceOutputDateTo;
    private boolean includeMoneySelector;

    public RnFilterDialog(Shell parentShell) {
        this(parentShell, true);
    }

    public RnFilterDialog(Shell parentShell, boolean includeMoneySelector) {
        super(parentShell);
        this.includeMoneySelector = includeMoneySelector;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        ret.setLayout((Layout)new GridLayout(4, false));
        if (this.includeMoneySelector) {
            new Label(ret, 0).setText(Messages.RnFilterDialog_amount);
            this.miVon = new MoneyInput(ret, FROM);
            this.miBis = new MoneyInput(ret, UNTIL);
        }
        Label lblBillDate = new Label(ret, 0);
        lblBillDate.setText(Messages.RnFilterDialog_billDate);
        lblBillDate.setLayoutData((Object)SWTHelper.getFillGridData(2, false, 1, true));
        this.diRnVon = new DateInput(ret, FROM);
        this.diRnBis = new DateInput(ret, UNTIL);
        Label lblStateDate = new Label(ret, 0);
        lblStateDate.setText(Messages.RnFilterDialog_stateDate);
        lblStateDate.setLayoutData((Object)SWTHelper.getFillGridData(2, false, 1, true));
        this.diStatVon = new DateInput(ret, FROM);
        this.diStatBis = new DateInput(ret, UNTIL);
        Label lblOutputDate = new Label(ret, 0);
        lblOutputDate.setText(Messages.RnFilterDialog_outputDate);
        Label lblOutputDateInfo = new Label(ret, 0);
        lblOutputDateInfo.setImage(Images.IMG_ACHTUNG.getImage());
        lblOutputDateInfo.setToolTipText(Messages.RnFilterDialog_outputDateInfo);
        this.diOutVon = new DateInput(ret, FROM);
        this.diOutBis = new DateInput(ret, UNTIL);
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.RnFilterDialog_billsFilterCaption);
        this.setMessage(Messages.RnFilterDialog_billsFilterMessage);
        this.getShell().setText(Messages.RnFilterDialog_billsList);
    }

    public TimeTool getInvoiceDateFrom() {
        return this.invoiceDateFrom;
    }

    public TimeTool getInvoiceDateTo() {
        return this.invoiceDateTo;
    }

    public TimeTool getInvoiceStateDateFrom() {
        return this.invoiceStateDateFrom;
    }

    public TimeTool getInvoiceStateDateTo() {
        return this.invoiceStateDateTo;
    }

    public TimeTool getInvoiceOutputDateFrom() {
        return this.invoiceOutputDateFrom;
    }

    public TimeTool getInvoiceOutputDateTo() {
        return this.invoiceOutputDateTo;
    }

    protected void okPressed() {
        ArrayList<String> al = new ArrayList<String>();
        if (this.includeMoneySelector) {
            Money mFrom = this.miVon.getMoney(true);
            Money mUntil = this.miBis.getMoney(true);
            if (mFrom != null) {
                al.add(PersistentObject.getConnection().translateFlavor("cast(Betrag as SIGNED) >=" + mFrom.getCentsAsString()));
            }
            if (mUntil != null) {
                al.add(PersistentObject.getConnection().translateFlavor("cast(Betrag as SIGNED) <=" + mUntil.getCentsAsString()));
            }
        }
        this.invoiceDateFrom = this.diRnVon.getDate();
        if (this.invoiceDateFrom != null) {
            al.add("RnDatum >=" + PersistentObject.getConnection().wrapFlavored(this.invoiceDateFrom.toString(9)));
        }
        this.invoiceDateTo = this.diRnBis.getDate();
        if (this.invoiceDateTo != null) {
            al.add("RnDatum <=" + PersistentObject.getConnection().wrapFlavored(this.invoiceDateTo.toString(9)));
        }
        this.invoiceStateDateFrom = this.diStatVon.getDate();
        if (this.invoiceStateDateFrom != null) {
            al.add("StatusDatum >=" + PersistentObject.getConnection().wrapFlavored(this.invoiceStateDateFrom.toString(9)));
        }
        this.invoiceStateDateTo = this.diStatBis.getDate();
        if (this.invoiceStateDateTo != null) {
            al.add("StatusDatum <=" + PersistentObject.getConnection().wrapFlavored(this.invoiceStateDateTo.toString(9)));
        }
        this.invoiceOutputDateFrom = this.diOutVon.getDate();
        this.invoiceOutputDateTo = this.diOutBis.getDate();
        this.ret = al.size() > 0 ? al.toArray(new String[0]) : null;
        super.okPressed();
    }
}

