/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.data.Fall;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.Result;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class DefaultOutputter
implements IRnOutputter {
    private ArrayList<IRnOutputter> configured = new ArrayList();

    public boolean canBill(Fall fall) {
        if (fall.getOutputter().getDescription().equals(this.getDescription())) {
            return false;
        }
        return fall.getOutputter().canBill(fall);
    }

    public boolean canStorno(Rechnung rn) {
        if (rn == null) {
            return false;
        }
        return rn.getFall().getOutputter().canStorno(rn);
    }

    public Object createSettingsControl(Object parent) {
        Composite parComposite = (Composite)parent;
        Label lbl = new Label(parComposite, 64);
        lbl.setText(Messages.DefaultOutputter_useIdividualPlugins);
        return lbl;
    }

    public Result<Rechnung> doOutput(IRnOutputter.TYPE type, Collection<Rechnung> rnn, Properties props) {
        Result res = new Result(null);
        props.setProperty("OutputMethod", "asDefault");
        for (Rechnung rn : rnn) {
            Fall fall = rn.getFall();
            final IRnOutputter iro = fall.getOutputter();
            if (!this.configured.contains(iro)) {
                SWTHelper.SimpleDialog dlg = new SWTHelper.SimpleDialog(new SWTHelper.IControlProvider(){

                    @Override
                    public Control getControl(Composite parent) {
                        parent.getShell().setText(iro.getDescription());
                        return (Control)iro.createSettingsControl((Object)parent);
                    }

                    @Override
                    public void beforeClosing() {
                        iro.saveComposite();
                    }
                });
                if (dlg.open() != 0) continue;
                this.configured.add(iro);
            }
            res.add(iro.doOutput(type, Arrays.asList(rn), props));
        }
        return null;
    }

    public String getDescription() {
        return Messages.DefaultOutputter_defaultOutputForCase;
    }

    public void saveComposite() {
    }
}

