/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.tools.Money;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class AccountListView
extends ViewPart
implements IActivationListener,
ISaveablePart2 {
    public static final String ID = "ch.elexis.views.rechnung.AccountListView";
    private FormToolkit tk;
    private Form form;
    private TableViewer accountListViewer;
    private static final int NAME = 0;
    private static final int FIRSTNAME = 1;
    private static final int BIRTHDATE = 2;
    private static final int SALDO = 3;
    private static final String[] COLUMN_TEXT = new String[]{Messages.AccountListView_name, Messages.AccountListView_firstname, Messages.AccountListView_bithdate, Messages.AccountListView_balance};
    private static final int[] COLUMN_WIDTH = new int[]{150, 150, 100, 100};
    private DataLoader loader;

    public void createPartControl(Composite parent) {
        this.loader = new DataLoader();
        parent.setLayout((Layout)new FillLayout());
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createForm(parent);
        this.form.getBody().setLayout((Layout)new GridLayout(1, false));
        this.tk.createLabel(this.form.getBody(), Messages.AccountListView_accountList);
        this.accountListViewer = new TableViewer(this.form.getBody(), 65540);
        Table table = this.accountListViewer.getTable();
        table.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn[] tc = new TableColumn[COLUMN_TEXT.length];
        int i = 0;
        while (i < COLUMN_TEXT.length) {
            tc[i] = new TableColumn(table, 0);
            tc[i].setText(COLUMN_TEXT[i]);
            tc[i].setWidth(COLUMN_WIDTH[i]);
            ++i;
        }
        this.accountListViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (AccountListView.this.loader.isValid()) {
                    Object result = AccountListView.this.loader.getData();
                    if (result instanceof Object[]) {
                        return (Object[])result;
                    }
                    return new Object[0];
                }
                AccountListView.this.loader.schedule();
                return new Object[]{Messages.AccountListView_loadingData};
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.accountListViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (!(element instanceof AccountListEntry)) {
                    return "";
                }
                AccountListEntry entry = (AccountListEntry)element;
                String text = "";
                switch (columnIndex) {
                    case 0: {
                        text = entry.name;
                        break;
                    }
                    case 1: {
                        text = entry.vorname;
                        break;
                    }
                    case 2: {
                        text = entry.geburtsdatum;
                        break;
                    }
                    case 3: {
                        text = entry.saldo.toString();
                    }
                }
                return text;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }
        });
        this.accountListViewer.setInput((Object)this.getViewSite());
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
    }

    public void setFocus() {
        this.accountListViewer.getControl().setFocus();
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        super.dispose();
    }

    @Override
    public void activation(boolean mode) {
    }

    @Override
    public void visible(boolean mode) {
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    class AccountListEntry {
        Patient patient;
        String name;
        String vorname;
        String geburtsdatum;
        Money saldo;

        AccountListEntry(Patient patient) {
            this.patient = patient;
            String[] values = new String[3];
            patient.get(new String[]{"Name", "Vorname", "Geburtsdatum"}, values);
            this.name = values[0];
            this.vorname = values[1];
            this.geburtsdatum = values[2];
            this.saldo = patient.getKontostand();
        }
    }

    class DataLoader
    extends BackgroundJob
    implements BackgroundJob.BackgroundJobListener {
        Integer size;

        DataLoader() {
            super("AccountListView");
            this.size = null;
            this.addListener(this);
        }

        @Override
        public IStatus execute(IProgressMonitor monitor) {
            ArrayList<AccountListEntry> entries = new ArrayList<AccountListEntry>();
            Query query = new Query(Patient.class);
            query.orderBy(false, new String[]{"Name", "Vorname"});
            List patients = query.execute();
            if (patients == null) {
                this.result = new Object[0];
            } else {
                for (Patient patient : patients) {
                    AccountListEntry entry = new AccountListEntry(patient);
                    entries.add(entry);
                }
                this.result = entries.toArray();
            }
            return Status.OK_STATUS;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public void jobFinished(BackgroundJob j) {
            AccountListView.this.accountListViewer.refresh();
        }
    }
}

