/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.controls;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.dialogs.ArticleDefaultSignatureTitleAreaDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.views.controls.Messages;
import ch.elexis.data.ArticleDefaultSignature;
import ch.elexis.data.Artikel;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public class ArticleDefaultSignatureComposite
extends Composite {
    private WritableValue signatureItem = new WritableValue(null, ArticleDefaultSignature.ArticleSignature.class);
    private DataBindingContext databindingContext;
    private ToolBarManager toolbarManager;
    private Text txtSignatureMorning;
    private Text txtSignatureNoon;
    private Text txtSignatureEvening;
    private Text txtSignatureNight;
    private Text txtSignatureComment;
    private Composite medicationType;
    private Button btnSymtomatic;
    private Button btnReserve;
    private Button btnFix;
    private Composite disposalType;
    private Button btnNoDisposal;
    private Button btnDispensation;
    private Composite signatureType;
    private Button btnRadioOnAtcCode;
    private Button btnRadioOnArticle;
    private Artikel article;
    private StackLayout stackLayoutDosage;
    private Composite compositeDayTimeDosage;
    private Text txtFreeTextDosage;
    private Composite compositeFreeTextDosage;
    private Composite stackCompositeDosage;
    private Composite compositeMedicationTypeDetail;
    private Label lblCalcEndDate;
    private List<SavingTargetToModelStrategy> targetToModelStrategies;

    public ArticleDefaultSignatureComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(7, false));
        this.signatureType = new Composite((Composite)this, 0);
        this.signatureType.setLayout((Layout)new RowLayout());
        this.signatureType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 6, 1));
        this.btnRadioOnAtcCode = new Button(this.signatureType, 16);
        this.btnRadioOnAtcCode.setText(Messages.ArticleDefaultSignatureComposite_onAtc);
        this.btnRadioOnAtcCode.addSelectionListener((SelectionListener)new SavingSelectionAdapter());
        this.btnRadioOnArticle = new Button(this.signatureType, 16);
        this.btnRadioOnArticle.setText(Messages.ArticleDefaultSignatureComposite_onArticle);
        this.btnRadioOnArticle.addSelectionListener((SelectionListener)new SavingSelectionAdapter());
        this.toolbarManager = new ToolBarManager();
        this.toolbarManager.add((IAction)new AddDefaultSignatureAction());
        this.toolbarManager.add((IAction)new RemoveDefaultSignatureAction());
        ToolBar toolbar = this.toolbarManager.createControl((Composite)this);
        toolbar.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.stackCompositeDosage = new Composite((Composite)this, 0);
        this.stackCompositeDosage.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 6, 1));
        this.stackLayoutDosage = new StackLayout();
        this.stackCompositeDosage.setLayout((Layout)this.stackLayoutDosage);
        this.compositeDayTimeDosage = new Composite(this.stackCompositeDosage, 0);
        GridLayout layout = new GridLayout(7, false);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        this.compositeDayTimeDosage.setLayout((Layout)layout);
        this.txtSignatureMorning = new Text(this.compositeDayTimeDosage, 2048);
        this.txtSignatureMorning.setMessage(Messages.ArticleDefaultSignatureComposite_morning);
        this.txtSignatureMorning.setToolTipText("");
        this.txtSignatureMorning.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label label = new Label(this.compositeDayTimeDosage, 0);
        label.setText("-");
        this.txtSignatureNoon = new Text(this.compositeDayTimeDosage, 2048);
        this.txtSignatureNoon.setMessage(Messages.ArticleDefaultSignatureComposite_noon);
        this.txtSignatureNoon.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label = new Label(this.compositeDayTimeDosage, 0);
        label.setText("-");
        this.txtSignatureEvening = new Text(this.compositeDayTimeDosage, 2048);
        this.txtSignatureEvening.setMessage(Messages.ArticleDefaultSignatureComposite_evening);
        this.txtSignatureEvening.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        label = new Label(this.compositeDayTimeDosage, 0);
        label.setText("-");
        this.txtSignatureNight = new Text(this.compositeDayTimeDosage, 2048);
        this.txtSignatureNight.setMessage(Messages.ArticleDefaultSignatureComposite_night);
        this.txtSignatureNight.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.compositeFreeTextDosage = new Composite(this.stackCompositeDosage, 0);
        layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        this.compositeFreeTextDosage.setLayout((Layout)layout);
        this.txtFreeTextDosage = new Text(this.compositeFreeTextDosage, 2048);
        this.txtFreeTextDosage.setMessage(Messages.ArticleDefaultSignatureComposite_dosage);
        this.txtFreeTextDosage.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.stackLayoutDosage.topControl = this.compositeDayTimeDosage;
        Button btnDoseSwitch = new Button((Composite)this, 0);
        btnDoseSwitch.setImage(Images.IMG_SYNC.getImage());
        btnDoseSwitch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((ArticleDefaultSignatureComposite)ArticleDefaultSignatureComposite.this).stackLayoutDosage.topControl == ArticleDefaultSignatureComposite.this.compositeDayTimeDosage) {
                    ((ArticleDefaultSignatureComposite)ArticleDefaultSignatureComposite.this).stackLayoutDosage.topControl = ArticleDefaultSignatureComposite.this.compositeFreeTextDosage;
                } else {
                    ((ArticleDefaultSignatureComposite)ArticleDefaultSignatureComposite.this).stackLayoutDosage.topControl = ArticleDefaultSignatureComposite.this.compositeDayTimeDosage;
                    ArticleDefaultSignatureComposite.this.txtFreeTextDosage.setText("");
                }
                ArticleDefaultSignatureComposite.this.stackCompositeDosage.layout();
            }
        });
        this.txtSignatureComment = new Text((Composite)this, 2048);
        this.txtSignatureComment.setMessage(Messages.ArticleDefaultSignatureComposite_applicationInstruction);
        this.txtSignatureComment.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 7, 1));
        this.medicationType = new Composite((Composite)this, 0);
        this.medicationType.setLayout((Layout)new RowLayout());
        this.medicationType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 7, 1));
        this.btnSymtomatic = new Button(this.medicationType, 16);
        this.btnSymtomatic.setText(Messages.ArticleDefaultSignatureComposite_sympomatic);
        this.btnSymtomatic.addSelectionListener((SelectionListener)new SavingSelectionAdapter());
        this.btnReserve = new Button(this.medicationType, 16);
        this.btnReserve.setText(Messages.ArticleDefaultSignatureComposite_reserve);
        this.btnReserve.addSelectionListener((SelectionListener)new SavingSelectionAdapter());
        this.btnFix = new Button(this.medicationType, 16);
        this.btnFix.setText(Messages.ArticleDefaultSignatureComposite_fix);
        this.btnFix.addSelectionListener((SelectionListener)new SavingSelectionAdapter());
        this.createMedicationTypeDetails(this);
        this.disposalType = new Composite((Composite)this, 0);
        this.disposalType.setLayout((Layout)new RowLayout());
        this.disposalType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 7, 1));
        this.btnNoDisposal = new Button(this.disposalType, 16);
        this.btnNoDisposal.setText(Messages.ArticleDefaultSignatureComposite_recipe);
        this.btnNoDisposal.addSelectionListener((SelectionListener)new SavingSelectionAdapter());
        this.btnDispensation = new Button(this.disposalType, 16);
        this.btnDispensation.setText(Messages.ArticleDefaultSignatureComposite_dispensation);
        this.btnDispensation.addSelectionListener((SelectionListener)new SavingSelectionAdapter());
    }

    private void createMedicationTypeDetails(Composite parent) {
        this.compositeMedicationTypeDetail = new Composite(parent, 0);
        this.compositeMedicationTypeDetail.setLayout((Layout)new GridLayout(4, false));
        this.compositeMedicationTypeDetail.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblEnddate = new Label(this.compositeMedicationTypeDetail, 0);
        lblEnddate.setText("Stoppdatum:");
        GridData gd = new GridData(4, 0x1000000, false, false);
        this.lblCalcEndDate = new Label(this.compositeMedicationTypeDetail, 0);
        gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = 80;
        this.lblCalcEndDate.setLayoutData((Object)gd);
        this.lblCalcEndDate.setText("(" + Messages.ArticleDefaultSignatureComposite_date_none + ")");
        this.lblCalcEndDate.setData(null);
        final Text txtEnddate = new Text(this.compositeMedicationTypeDetail, 0x1000800);
        txtEnddate.setText("");
        gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = 30;
        txtEnddate.setLayoutData((Object)gd);
        Label lblDays = new Label(this.compositeMedicationTypeDetail, 0);
        lblDays.setText("Tage");
        txtEnddate.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int days = Integer.parseInt(txtEnddate.getText());
                    TimeTool t = new TimeTool();
                    if (days > 182500) {
                        days = 182500;
                    }
                    if (days < 0) {
                        days = 0;
                    }
                    t.addDays(days);
                    ArticleDefaultSignatureComposite.this.lblCalcEndDate.setText("(" + t.toString(4) + ")");
                    ArticleDefaultSignatureComposite.this.lblCalcEndDate.setData((Object)t);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    ArticleDefaultSignatureComposite.this.lblCalcEndDate.setText("(" + Messages.ArticleDefaultSignatureComposite_date_none + ")");
                    ArticleDefaultSignatureComposite.this.lblCalcEndDate.setData(null);
                    return;
                }
            }
        });
        this.updateMedicationTypeDetails();
    }

    public void updateMedicationTypeDetails() {
        if (this.compositeMedicationTypeDetail != null) {
            boolean visible = this.btnSymtomatic != null && this.btnSymtomatic.getSelection();
            this.compositeMedicationTypeDetail.setVisible(visible);
            GridData data = (GridData)this.compositeMedicationTypeDetail.getLayoutData();
            data.exclude = !visible;
            this.compositeMedicationTypeDetail.getParent().layout();
        }
    }

    public void setToolbarVisible(boolean value) {
        ToolBar toolbar = this.toolbarManager.getControl();
        if (toolbar != null && !toolbar.isDisposed()) {
            toolbar.setVisible(value);
        }
    }

    public void setOnLocationEnabled(boolean value) {
        this.btnRadioOnArticle.setEnabled(value);
        this.btnRadioOnAtcCode.setEnabled(value);
    }

    public void setMedicationTypeFix() {
        this.medicationType.setVisible(false);
        this.btnFix.setSelection(true);
        this.btnSymtomatic.setSelection(false);
        this.btnReserve.setSelection(false);
        this.medicationType.getParent().layout();
        this.updateMedicationTypeDetails();
    }

    public DataBindingContext initDataBindings(DataBindingContext dbc) {
        this.databindingContext = dbc == null ? new DataBindingContext() : dbc;
        this.targetToModelStrategies = new ArrayList<SavingTargetToModelStrategy>();
        ISWTObservableValue observeTextTextSignatureMorningObserveWidget = WidgetProperties.text((int[])new int[]{24, 16}).observeDelayed(100, (Widget)this.txtSignatureMorning);
        IObservableValue itemSignatureMorningObserveDetailValue = PojoProperties.value(ArticleDefaultSignature.ArticleSignature.class, (String)"morning", String.class).observeDetail((IObservableValue)this.signatureItem);
        SavingTargetToModelStrategy targetToModelStrategy = new SavingTargetToModelStrategy(this);
        this.targetToModelStrategies.add(targetToModelStrategy);
        this.databindingContext.bindValue((IObservableValue)observeTextTextSignatureMorningObserveWidget, itemSignatureMorningObserveDetailValue, (UpdateValueStrategy)targetToModelStrategy, null);
        ISWTObservableValue observeTextTextSignatureNoonObserveWidget = WidgetProperties.text((int[])new int[]{24, 16}).observeDelayed(100, (Widget)this.txtSignatureNoon);
        IObservableValue itemSignatureNoonObserveDetailValue = PojoProperties.value(ArticleDefaultSignature.ArticleSignature.class, (String)"noon", String.class).observeDetail((IObservableValue)this.signatureItem);
        targetToModelStrategy = new SavingTargetToModelStrategy(this);
        this.targetToModelStrategies.add(targetToModelStrategy);
        this.databindingContext.bindValue((IObservableValue)observeTextTextSignatureNoonObserveWidget, itemSignatureNoonObserveDetailValue, (UpdateValueStrategy)targetToModelStrategy, null);
        ISWTObservableValue observeTextTextSignatureEveningObserveWidget = WidgetProperties.text((int[])new int[]{24, 16}).observeDelayed(100, (Widget)this.txtSignatureEvening);
        IObservableValue itemSignatureEveningObserveDetailValue = PojoProperties.value(ArticleDefaultSignature.ArticleSignature.class, (String)"evening", String.class).observeDetail((IObservableValue)this.signatureItem);
        targetToModelStrategy = new SavingTargetToModelStrategy(this);
        this.targetToModelStrategies.add(targetToModelStrategy);
        this.databindingContext.bindValue((IObservableValue)observeTextTextSignatureEveningObserveWidget, itemSignatureEveningObserveDetailValue, (UpdateValueStrategy)targetToModelStrategy, null);
        ISWTObservableValue observeTextTextSignatureNightObserveWidget = WidgetProperties.text((int[])new int[]{24, 16}).observeDelayed(100, (Widget)this.txtSignatureNight);
        IObservableValue itemSignatureNightObserveDetailValue = PojoProperties.value(ArticleDefaultSignature.ArticleSignature.class, (String)"night", String.class).observeDetail((IObservableValue)this.signatureItem);
        targetToModelStrategy = new SavingTargetToModelStrategy(this);
        this.targetToModelStrategies.add(targetToModelStrategy);
        this.databindingContext.bindValue((IObservableValue)observeTextTextSignatureNightObserveWidget, itemSignatureNightObserveDetailValue, (UpdateValueStrategy)targetToModelStrategy, null);
        ISWTObservableValue observeTextFreeTextDosageObserveWidget = WidgetProperties.text((int[])new int[]{24, 16}).observeDelayed(100, (Widget)this.txtFreeTextDosage);
        IObservableValue itemSignatureFreeTextDosageObserveDetailValue = PojoProperties.value(ArticleDefaultSignature.ArticleSignature.class, (String)"freeText", String.class).observeDetail((IObservableValue)this.signatureItem);
        targetToModelStrategy = new SavingTargetToModelStrategy(this);
        this.targetToModelStrategies.add(targetToModelStrategy);
        this.databindingContext.bindValue((IObservableValue)observeTextFreeTextDosageObserveWidget, itemSignatureFreeTextDosageObserveDetailValue, (UpdateValueStrategy)targetToModelStrategy, null);
        ISWTObservableValue observeTextTextSignatureCommentObserveWidget = WidgetProperties.text((int[])new int[]{24, 16}).observeDelayed(100, (Widget)this.txtSignatureComment);
        IObservableValue itemSignatureCommentObserveDetailValue = PojoProperties.value(ArticleDefaultSignature.ArticleSignature.class, (String)"comment", String.class).observeDetail((IObservableValue)this.signatureItem);
        targetToModelStrategy = new SavingTargetToModelStrategy(this);
        this.targetToModelStrategies.add(targetToModelStrategy);
        this.databindingContext.bindValue((IObservableValue)observeTextTextSignatureCommentObserveWidget, itemSignatureCommentObserveDetailValue, (UpdateValueStrategy)targetToModelStrategy, null);
        return this.databindingContext;
    }

    protected void checkSubclass() {
    }

    public void setArticleToBind(Artikel article, boolean lookup) {
        if (!this.isDisposed()) {
            ArticleDefaultSignature.ArticleSignature signature = this.getSignature();
            if (signature != null && signature.isPersistent()) {
                signature.toDefault();
            }
            this.article = article;
            if (lookup) {
                ArticleDefaultSignature defSignature = ArticleDefaultSignature.getDefaultsignatureForArticle((Artikel)article);
                if (defSignature != null) {
                    this.signatureItem.setValue((Object)ArticleDefaultSignature.ArticleSignature.fromDefault((ArticleDefaultSignature)defSignature));
                } else {
                    this.signatureItem.setValue((Object)new ArticleDefaultSignature.ArticleSignature(article, null));
                }
            } else {
                this.signatureItem.setValue((Object)new ArticleDefaultSignature.ArticleSignature(article, null));
            }
            this.updateTargetNonDatabinding();
            IContributionItem[] iContributionItemArray = this.toolbarManager.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                item.update();
                ++n2;
            }
        }
    }

    public void setArticleToBind(Artikel article) {
        this.setArticleToBind(article, true);
    }

    public ArticleDefaultSignature.ArticleSignature getSignature() {
        Object value = this.signatureItem.getValue();
        if (value instanceof ArticleDefaultSignature.ArticleSignature) {
            return (ArticleDefaultSignature.ArticleSignature)value;
        }
        return null;
    }

    public void updateModelNonDatabinding() {
        ArticleDefaultSignature.ArticleSignature signature = this.getSignature();
        if (signature != null) {
            if (this.btnRadioOnAtcCode.getSelection()) {
                signature.setAtcCode(this.article.getATC_code());
            } else if (this.btnRadioOnArticle.getSelection()) {
                signature.setAtcCode(null);
                signature.setArticle(this.article);
            }
            if (this.btnSymtomatic.getSelection()) {
                signature.setMedicationType(EntryType.SYMPTOMATIC_MEDICATION);
            } else if (this.btnReserve.getSelection()) {
                signature.setMedicationType(EntryType.RESERVE_MEDICATION);
            } else if (this.btnFix.getSelection()) {
                signature.setMedicationType(EntryType.FIXED_MEDICATION);
            }
            if (this.btnNoDisposal.getSelection()) {
                signature.setDisposalType(EntryType.RECIPE);
            } else if (this.btnDispensation.getSelection()) {
                signature.setDisposalType(EntryType.SELF_DISPENSED);
            }
            if (this.lblCalcEndDate != null) {
                signature.setEndDate(this.lblCalcEndDate.getData() instanceof TimeTool ? (TimeTool)this.lblCalcEndDate.getData() : null);
            }
        }
        this.updateMedicationTypeDetails();
    }

    public void updateTargetNonDatabinding() {
        ArticleDefaultSignature.ArticleSignature signature = this.getSignature();
        String freeText = signature.getFreeText();
        this.stackLayoutDosage.topControl = freeText != null && !freeText.isEmpty() ? this.compositeFreeTextDosage : this.compositeDayTimeDosage;
        this.stackCompositeDosage.layout();
        this.btnFix.setSelection(false);
        this.btnReserve.setSelection(false);
        this.btnSymtomatic.setSelection(false);
        this.btnNoDisposal.setSelection(false);
        this.btnDispensation.setSelection(false);
        this.btnRadioOnArticle.setSelection(false);
        this.btnRadioOnAtcCode.setSelection(false);
        if (signature != null) {
            EntryType modelMedicationType = signature.getMedicationType();
            if (modelMedicationType == EntryType.FIXED_MEDICATION) {
                this.btnFix.setSelection(true);
            } else if (modelMedicationType == EntryType.RESERVE_MEDICATION) {
                this.btnReserve.setSelection(true);
            } else if (modelMedicationType == EntryType.SYMPTOMATIC_MEDICATION) {
                this.btnSymtomatic.setSelection(true);
            } else {
                this.btnSymtomatic.setSelection(true);
            }
            EntryType modelDisposalType = signature.getDisposalType();
            if (modelDisposalType == EntryType.RECIPE) {
                this.btnNoDisposal.setSelection(true);
            } else if (modelDisposalType == EntryType.SELF_DISPENSED) {
                this.btnDispensation.setSelection(true);
            } else if (CoreHub.userCfg.get("medication/settings/signatureStdDispensation", false)) {
                this.btnDispensation.setSelection(true);
            } else {
                this.btnNoDisposal.setSelection(true);
            }
            if (signature.isAtc()) {
                this.btnRadioOnAtcCode.setSelection(true);
            } else {
                this.btnRadioOnArticle.setSelection(true);
            }
        }
        this.updateMedicationTypeDetails();
    }

    public void safeToDefault() {
        ArticleDefaultSignature.ArticleSignature signature = this.getSignature();
        if (!(this.btnFix.getSelection() || this.btnReserve.getSelection() || this.btnSymtomatic.getSelection())) {
            return;
        }
        if (signature != null) {
            signature.toDefault();
        }
    }

    public void createPersistent() {
        ArticleDefaultSignature.ArticleSignature signature = this.getSignature();
        if (!signature.isPersistent()) {
            signature.createPersistent();
        }
    }

    public String getSignatureMorning() {
        return this.txtSignatureMorning.getText();
    }

    public void setSignatureMorning(String signatureMorning) {
        this.txtSignatureMorning.setText(signatureMorning);
    }

    public String getSignatureNoon() {
        return this.txtSignatureNoon.getText();
    }

    public void setSignatureNoon(String signatureNoon) {
        this.txtSignatureNoon.setText(signatureNoon);
    }

    public String getSignatureEvening() {
        return this.txtSignatureEvening.getText();
    }

    public void setSignatureEvening(String signatureEvening) {
        this.txtSignatureEvening.setText(signatureEvening);
    }

    public String getSignatureNight() {
        return this.txtSignatureNight.getText();
    }

    public void setSignatureNight(String signatureNight) {
        this.txtSignatureNight.setText(signatureNight);
    }

    public String getSignatureComment() {
        return this.txtSignatureComment.getText();
    }

    public void setSignatureComment(String signatureComment) {
        this.txtSignatureComment.setText(signatureComment);
    }

    public void setSignature(ArticleDefaultSignature.ArticleSignature signature) {
        this.signatureItem.setValue((Object)signature);
        this.updateTargetNonDatabinding();
    }

    public void setAutoSave(boolean value) {
        if (this.targetToModelStrategies != null) {
            for (SavingTargetToModelStrategy savingTargetToModelStrategy : this.targetToModelStrategies) {
                savingTargetToModelStrategy.setAutoSave(value);
            }
        }
    }

    private class AddDefaultSignatureAction
    extends Action {
        private AddDefaultSignatureAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_NEW.getImageDescriptor();
        }

        public void run() {
            ArticleDefaultSignatureTitleAreaDialog dialog = new ArticleDefaultSignatureTitleAreaDialog(ArticleDefaultSignatureComposite.this.getShell(), ArticleDefaultSignatureComposite.this.article);
            dialog.open();
            ArticleDefaultSignatureComposite.this.setArticleToBind(ArticleDefaultSignatureComposite.this.article);
        }

        public boolean isEnabled() {
            ArticleDefaultSignature.ArticleSignature signature = ArticleDefaultSignatureComposite.this.getSignature();
            return signature == null || !signature.isPersistent() || signature.isAtc();
        }
    }

    private class RemoveDefaultSignatureAction
    extends Action {
        private RemoveDefaultSignatureAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_DELETE.getImageDescriptor();
        }

        public void run() {
            ArticleDefaultSignature.ArticleSignature signature = ArticleDefaultSignatureComposite.this.getSignature();
            if (signature != null && signature.isPersistent()) {
                signature.delete();
            }
            ArticleDefaultSignatureComposite.this.setArticleToBind(ArticleDefaultSignatureComposite.this.article);
        }

        public boolean isEnabled() {
            ArticleDefaultSignature.ArticleSignature signature = ArticleDefaultSignatureComposite.this.getSignature();
            return signature != null && signature.isPersistent();
        }
    }

    private class SavingSelectionAdapter
    extends SelectionAdapter {
        private SavingSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            ArticleDefaultSignatureComposite.this.updateModelNonDatabinding();
            ArticleDefaultSignatureComposite.this.safeToDefault();
        }
    }

    private static class SavingTargetToModelStrategy
    extends UpdateValueStrategy {
        private boolean autoSave;
        private ArticleDefaultSignatureComposite composite;

        public SavingTargetToModelStrategy(ArticleDefaultSignatureComposite composite) {
            this.composite = composite;
        }

        public void setAutoSave(boolean value) {
            this.autoSave = value;
        }

        protected IStatus doSet(IObservableValue observableValue, Object value) {
            IStatus ret = super.doSet(observableValue, value);
            if (this.autoSave) {
                this.composite.safeToDefault();
            }
            return ret;
        }
    }
}

